
# settings.py
"""配置文件"""
import os
from typing import Dict, Any

# LLM配置
class LLMConfig:
    BASE_URL = os.getenv("LLM_BASE_URL", "http://your-llm-service-url")
    ROUTE = os.getenv("LLM_ROUTE", "/v1/chat/completions")
    API_KEY = os.getenv("LLM_API_KEY", "your-api-key")
    MAX_RETRIES = int(os.getenv("LLM_MAX_RETRIES", "3"))
    TIMEOUT = int(os.getenv("LLM_TIMEOUT", "30"))

# 文件路径配置
class PathConfig:
    CORPUS_FILE = os.getenv("CORPUS_FILE", "sales_corpus.csv")
    TAGS_FILE = os.getenv("TAGS_FILE", "sales_tags.csv")
    CHANNEL_CONFIG = os.getenv("CHANNEL_CONFIG", "channel_activity.yaml")
    LOG_FILE = os.getenv("LOG_FILE", "sales_analysis.log")

# 销售违规场景定义
SALES_VIOLATIONS: Dict[str, list] = {
    "虚假信息": ["空壳公司", "挂靠", "不用注销户籍", "自动延续", "享受本地待遇"],
    "过度承诺": ["肯定", "一定", "保证", "100%", "绝对"],
    "不当建议": ["随便找", "不用着急", "来得及", "自雇"],
    "违法建议": ["虚假证明", "造假", "修改材料"],
}

# 销售质量评估标准
SALES_QUALITY_METRICS: Dict[str, Dict[str, Any]] = {
    "专业性": {
        "weight": 0.3,
        "factors": ["产品知识准确", "政策解释清晰", "专业术语使用恰当"]
    },
    "合规性": {
        "weight": 0.3,
        "factors": ["无违规承诺", "无虚假信息", "无不当建议"]
    },
    "服务态度": {
        "weight": 0.2,
        "factors": ["礼貌用语", "耐心解答", "积极主动"]
    },
    "沟通技巧": {
        "weight": 0.2,
        "factors": ["需求挖掘", "异议处理", "总结复述"]
    }
}

# 分析配置
class AnalysisConfig:
    MIN_DIALOGUE_LENGTH = int(os.getenv("MIN_DIALOGUE_LENGTH", "50"))
    MAX_DIALOGUE_LENGTH = int(os.getenv("MAX_DIALOGUE_LENGTH", "3000"))
    BATCH_SIZE = int(os.getenv("BATCH_SIZE", "10"))
    SCORE_THRESHOLD = float(os.getenv("SCORE_THRESHOLD", "0.6"))

# 日志配置
class LogConfig:
    LEVEL = os.getenv("LOG_LEVEL", "INFO")
    FORMAT = '%(asctime)s - %(levelname)s - %(message)s'
    ENCODING = 'utf-8'
