//
//  YHAddIncomeRecordCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAddIncomeRecordCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHAddIncomeRecordCell"
    var addButtonClickEvent: (() -> Void)?

    private lazy var addItemView: YHWorkItemAddView = {
        let view = YHWorkItemAddView()
        view.addBtn.setTitle("新增收入/工作信息".local, for: .normal)
        view.addBtn.setImage(UIImage(named: "income_item_add"), for: .normal)
        view.clickBlock = { [weak self] in
            guard let self = self else { return }
            self.addButtonClickEvent?()
        }
        return view
    }()
    
    private lazy var infoFailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .failColor
        label.text = "请新增"
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(_ addTitle: String, needShowFailButton: Bool) {
        addItemView.addBtn.setTitle(addTitle.local, for: .normal)
        updateFailLabel(needShowFailButton)
    }
}

extension YHAddIncomeRecordCell {
    private func updateFailLabel(_ needShowFailButton: Bool) {
        if needShowFailButton {
            infoFailLabel.isHidden = false
            addItemView.snp.remakeConstraints { make in
                make.top.equalToSuperview().offset(16)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.height.equalTo(44)
            }
            infoFailLabel.snp.remakeConstraints { make in
                make.top.equalTo(addItemView.snp.bottom).offset(6)
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            infoFailLabel.isHidden = true
            addItemView.snp.remakeConstraints { make in
                make.top.equalToSuperview().offset(16)
                make.bottom.equalToSuperview().offset(-16)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.height.equalTo(44)
            }
            infoFailLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
    }
    
    private func setupUI() {
        updateCellCorner(.bottom)
        subContainerView.addSubview(addItemView)
        subContainerView.addSubview(infoFailLabel)
        
        addItemView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(44)
        }
        infoFailLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-16)
        }
    }
}
