//
//  YHWorkMessageSelectTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkMessageSelectTableViewCell: UITableViewCell {
    typealias IsNeedFileBlock = (_ isNeed: Int) -> Void
    var isNeedFileBlock: IsNeedFileBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var lineView: UIView!
    var subTitleLabel: UILabel!
    var leftButton: UIButton!
    var rightButton: UIButton!
    var dataSource: Int? {
        didSet {
            var flag = false
            if dataSource == 1 {
                flag = true
            }
            buttonState(isLeft: flag)
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "信息选择"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-18)
        }
        
        lineView = {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            return line
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        subTitleLabel = {
            let label = UILabel()
            let str = "*" + "是否与上份工作的“简历/工作总结”一致"
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 14),
                .foregroundColor: UIColor(hex: 0x4e4e4e)
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 1)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            label.attributedText = questionAttrStr
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(68)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        rightButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.setTitle("是", for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 13)
            button.layer.cornerRadius = 16
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.isSelected = true
            button.addTarget(self, action: #selector(rightClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(rightButton)
        rightButton.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.bottom.equalTo(-16)
            make.height.equalTo(32)
            make.width.equalTo(69)
        }
        
        leftButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor = UIColor.contentBkgColor
            button.setTitleColor(UIColor.brandMainColor, for: .selected)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.setTitle("否", for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 13)
            button.layer.cornerRadius = 16
            button.addTarget(self, action: #selector(leftClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(leftButton)
        leftButton.snp.makeConstraints { make in
            make.left.equalTo(rightButton.snp.right).offset(8)
            make.bottom.equalTo(-16)
            make.height.equalTo(32)
            make.width.equalTo(69)
        }
    }
    
    func buttonState(isLeft: Bool) {
        if isLeft {
            rightButton.isSelected = true
            leftButton.isSelected = false
            rightButton.layer.borderWidth = 1
            rightButton.layer.borderColor = UIColor.brandMainColor.cgColor
            rightButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
            leftButton.backgroundColor = UIColor.contentBkgColor
            leftButton.layer.borderWidth = 0
        } else {
            leftButton.isSelected = true
            rightButton.isSelected = false
            leftButton.layer.borderWidth = 1
            leftButton.layer.borderColor = UIColor.brandMainColor.cgColor
            leftButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
            rightButton.backgroundColor = UIColor.contentBkgColor
            rightButton.layer.borderWidth = 0
        }
    }
    
    @objc func rightClick() {
        rightButton.isSelected = true
        leftButton.isSelected = false
        rightButton.layer.borderWidth = 1
        rightButton.layer.borderColor = UIColor.brandMainColor.cgColor
        rightButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
        leftButton.backgroundColor = UIColor.contentBkgColor
        leftButton.layer.borderWidth = 0
        if let block = isNeedFileBlock {
            block(1)
        }
    }
    
    @objc func leftClick() {
        leftButton.isSelected = true
        rightButton.isSelected = false
        leftButton.layer.borderWidth = 1
        leftButton.layer.borderColor = UIColor.brandMainColor.cgColor
        leftButton.backgroundColor = UIColor.brandMainColor.withAlphaComponent(0.08)
        rightButton.backgroundColor = UIColor.contentBkgColor
        rightButton.layer.borderWidth = 0
        if let block = isNeedFileBlock {
            block(0)
        }
    }
   
}
