//
//  BsConstant.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/19.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit
import ESTabBarController_swift

// MARK: - 统一上传图片的最大值
let picMaxSize: Int = 2 * 1024 * 1024

// MARK: - 工程中的 常量定义
let APP_NAME = Bundle.main.infoDictionary!["CFBundleName"] as? String ?? ""

/// 打印
///
/// - Parameters:
///   - message: 打印内容
///   - file: 所在文件
///   - method: 所在方法
///   - line: 所在行
public func printLog<T>(_ message: T, file: String = #file, method: String = #function, line: Int = #line) {
#if DEBUG
    print("\n开始一段日志输出=========>\n[文件]:\((file as NSString).lastPathComponent)\n[所在行]:\(line)\n[方法名称]:\(method)\n[打印信息]:\(message)\n结束该段日志输出<=========")
#endif
}

// 边距
let kMargin: CGFloat = 16.0

// 圆角
let kCornerRadius2: CGFloat = 2.0
let kCornerRadius3: CGFloat = 3.0
let kCornerRadius4: CGFloat = 4.0
let kCornerRadius6: CGFloat = 6.0
let kCornerRadius8: CGFloat = 8.0
let kCornerRadius12: CGFloat = 12.0

/// 屏幕宽度
let KScreenWidth = UIScreen.main.bounds.size.width
/// 屏幕高度
let KScreenHeight = UIScreen.main.bounds.size.height
/// 导航栏高度
let k_Height_NavContentBar: CGFloat = 44.0
/** 状态栏高度 */
let k_Height_StatusBar: CGFloat = k_Height_statusBar()
/** 状态栏+导航栏的高度 */
let k_Height_NavigationtBarAndStatuBar: CGFloat = k_Height_NavContentBar + k_Height_StatusBar
/** 底部tabBar栏高度（不包含安全区，即：在 iphoneX 之前的手机） */
let k_TabBar_Height: CGFloat = 49.0
/** 底部导航栏高度（包括安全区），一般使用这个值 */
let k_Height_TabBar: CGFloat = k_Height_safeAreaInsetsBottom() + k_TabBar_Height

// 比例
let kRadio = KScreenWidth / 375.0

// MARK: - 尺寸信息： -
/* 状态栏高度  20 或 44 */
// 然而从iOS 14开始，全面屏iPhone的状态栏高度不一定是 44 或 20 了，比如下面就是这些设备在iOS 14.1上的状态栏高度。（还可能时47、48）
/// ①、顶部状态栏高度（包括安全区）
func k_Height_statusBar() -> CGFloat {
    var statusBarHeight: CGFloat = 0
    if #available(iOS 13.0, *) {
        let scene = UIApplication.shared.connectedScenes.first
        guard let windowScene = scene as? UIWindowScene else {return 0}
        guard let statusBarManager = windowScene.statusBarManager else {return 0}
        statusBarHeight = statusBarManager.statusBarFrame.height
    } else {
        statusBarHeight = UIApplication.shared.statusBarFrame.height
    }
    return statusBarHeight
}

/// ②、顶部安全区高度 k_Height_safeAreaInsetsTop
func k_Height_safeAreaInsetsTop() -> CGFloat {
    if #available(iOS 13.0, *) {
        let scene = UIApplication.shared.connectedScenes.first
        guard let windowScene = scene as? UIWindowScene else {return 0} // guard：如果 expression 值计算为false，则执行代码块内的 guard 语句。(必须包含一个控制语句: return、 break、 continue 或 throw。)。as?：类型转换，(还有这两种：as、as!)
        guard let window = windowScene.windows.first else {return 0}
        return window.safeAreaInsets.top
    }
    return 0
}

/// ③、底部安全区高度
func k_Height_safeAreaInsetsBottom() -> CGFloat {
    if #available(iOS 13.0, *) {
        let scene = UIApplication.shared.connectedScenes.first
        guard let windowScene = scene as? UIWindowScene else {return 0}
        guard let window = windowScene.windows.first else {return 0}
        return window.safeAreaInsets.bottom
    }
    return 0
}

/// 获取系统版本号
func IOSVersion() -> Double {
    return (UIDevice.current.systemVersion as NSString).doubleValue
}
/// 组件化用类名创建控制器
func ClassFromString(className: String) -> UIViewController? {
    let appName = Bundle.main.object(forInfoDictionaryKey: "CFBundleName")
    
    let name = "\(appName!).\(className)"
    if let tmpClass = NSClassFromString(name) as? UIViewController.Type {
        return tmpClass.init()
    } else {
        return nil
    }
}

/// 版本号相同：
func systemVersionEqual(version: String) -> Bool {
    return UIDevice.current.systemVersion == version
}

/// 系统版本高于等于该version  测试发现只能传入带一位小数点的版本号  不然会报错    具体原因待探究
func systemVersionGreaterThan(version: String) -> Bool {
    return UIDevice.current.systemVersion.compare(version, options: .numeric, range: version.startIndex..<version.endIndex, locale: Locale(identifier: version)) != ComparisonResult.orderedAscending
}

// 判断是否是 x、及x以上 系列
func isIphoneX() -> Bool {
    return k_Height_safeAreaInsetsBottom() > 0.0 // 底部安全区 > 0 时，
}

enum TabBarPageType: Int {
    case home // 首页
    case service // 服务
//    case message //消息
    case mine // 我的
    case community // 社区
    case AI  // 港小宝
}

func goTabBarBy(tabType: TabBarPageType) {

    var tabIndex: Int = 0
    switch tabType {
    case .home:
        tabIndex = 0
    case .service:
        tabIndex = 1
    case .AI:
        tabIndex = 2
    case .community:
        tabIndex = 3
    case .mine:
        tabIndex = 4
    }
    
    if tabType == .AI {
        let vc = YHAITabViewController()
        UIViewController.current?.navigationController?.pushViewController(vc)
        
    } else {
        if let vc = UIApplication.shared.keyWindow?.rootViewController as? YHTabBarViewController {
            vc.selectedIndex = tabIndex
        }
    }
}

func goToMessagePage(_ userInfo: [AnyHashable: Any]? = nil) {
    goTabBarBy(tabType: .community)
    UIViewController.current?.navigationController?.popToRootViewController(animated: true)
    DispatchQueue.main.asyncAfter(deadline: .now() + 0.25) {
        NotificationCenter.default.post(name: YhConstant.YhNotification.goMessageVCNotifiction, object: nil, userInfo: userInfo)
    }
}

func configTabBarController() -> YHTabBarViewController {
    
    let tabBarController = YHTabBarViewController()
    let homeVC = YHHomeHoldViewPageViewController()
    tabBarController.delegate = homeVC
    let v0 = YHNavigationController(rootVC: homeVC)
    let v1 = YHNavigationController(rootVC: YHServiceCenterViewController())
    let v2 = YHNavigationController(rootVC: YHAITabViewController())
    let v3 = YHNavigationController(rootVC: YHCommunityViewController())
    let v4 = YHNavigationController(rootVC: YHMyNewViewController())
    
    // 截获AI tabbarItem 点击事件
    let ai_tabIndex = 2
    tabBarController.shouldHijackHandler = {
        _, _, index in
        if index == ai_tabIndex {
            return true
        }
        return false
    }
    
    v0.tabBarItem = ESTabBarItem.init(YHHomeLottieAnimateContentView(), title: "首页", image: UIImage(named: "home"), selectedImage: UIImage(named: "home_1"))
    
    v1.tabBarItem = ESTabBarItem.init(YHServiceLottieAnimateContentView(), title: "服务", image: UIImage(named: "service"), selectedImage: UIImage(named: "service_1"))
    
    v2.tabBarItem = ESTabBarItem.init(YHAITabBarItemContentView(), title: "港小宝", image: UIImage(named: "service"), selectedImage: UIImage(named: "service_1"))
    
    v3.tabBarItem = ESTabBarItem.init(YHCommunityLottieAnimateContentView(), title: "朋友", image: UIImage(named: "msg"), selectedImage: UIImage(named: "msg_1"))
    
    v4.tabBarItem = ESTabBarItem.init(YHMyLottieAnimateContentView(), title: "我的", image: UIImage(named: "me"), selectedImage: UIImage(named: "me_1"))
    
    tabBarController.viewControllers = [v0, v1, v2, v3, v4]
    tabBarController.tabBar.backgroundColor = .white
    return tabBarController
}

// MARK: - 常量定义
class YhConstant {
    // MARK: - 登录信息
    static let KLoginedInfoKey = "KLoginedInfoKey"
    
    // 登录后的用户信息
    static let kLoginUserInfo = "loginUserInfo"
    
    static let kShowAlertOfSuggestLatestVersion = "show_alert_suggest_latest_version"
    
}

extension YhConstant {
    
    // DeepLink 常量
    struct DeepLink {
        static let urlPreUrlFix = "https://yinheapp.drcn.agconnect.link"
        static let url = "yinheapp://hkdiy-h5.galaxy-immi.com/galaxyapp"
        static let compareUrl = "yinheapp://hkdiy-h5.galaxy-immi.com/galaxyapp?type="
        
    }
    
    // MARK: - 环信IM
    struct IM {
   
// 此处的appName 是在七鱼后台管理系统配置
#if DEBUG
        static let appKey = "1126241122157016#demo"
#elseif TESTENV
        static let appKey = "1126241122157016#demo"
#elseif UATENV
        static let appKey = "1126241122157016#galaxy-app"
#else
        static let appKey = "1126241122157016#galaxy-app"
#endif
    }
    
    // MARK: - bugly
    struct Bugly {
        static let appidForTest = "3b10faa43e"
        static let appidForRelease = "5dc2acc53e"
    }
    
    // MARK: - 神策
    struct SensorsAnalytics {
        static let urlForTest = "https://importsensors.galaxy-immi.com/sa?project=default"
        static let urlForRelease = "https://importsensors.galaxy-immi.com/sa?project=production_1"
    }
    
    // MARK: - 极光推送
    struct Jpush {
        static let appKey = "c6a9e10575b85ee90f3e8afe"
    }
    
    // MARK: - 微信相关
    struct Wechat {
        static let appKey = "wx06b21f3c7a5ba594"
        static let universalLink = "https://www.galaxy-immi.com/app1/"
    }
    
    // MARK: - 支付宝
    struct Alipay {
        // MARK: - 阿里云 手机号一键登录 秘钥信息
        static let kAliLoginDefaultSecretKey = "y4uQwHhb6PBfQVKlHou8SINaWIFHkovMalxWpiSjmV7iree+qKEEZHunaf5VN7d+YmHZIu8th0V1mM+JUCSNqrTT1s/rN1KCu5tWtABgzYuIhHoUtzPMB2NbRoQUF/cJj2DAjpvRQwWibWONTVyvtKUVUqhiL+fbYXM4OzXETetCAykppYUQt2Tzob9Jwz2RwOC7WrU4QyOyoa5dbavOysUjo2yv3oTRVFQbE1wdZBczDWpiqHfqUArZ4py7Q5sVuGvCoCvRcAE="
        
    }
    
    // MARK: - 七鱼客服系统SDK
    struct QiYuSDK {
        static let appKey = "7922dbeb48141b15d2ae2e91cc156af5"
   
// 此处的appName 是在七鱼后台管理系统配置
#if DEBUG
        static let appName = "银河港生活iOS-Dev"
#elseif TESTENV
        static let appName = "银河港生活iOS"
#elseif UATENV
        static let appName = "银河港生活iOS"
#else
        static let appName = "银河港生活iOS"
#endif
    }
    
    struct AgoraRtcKit {
        
#if DEBUG
        static let appId: String = "84bcfa8857944dc58eca80d966a055ae" // 测试环境
#elseif TESTENV
        static let appId: String = "84bcfa8857944dc58eca80d966a055ae" // 测试环境
#elseif UATENV
        static let appId: String = "84bcfa8857944dc58eca80d966a055ae" // 正式环境
#else
        static let appId: String = "f1da9c5b9fb946148761278273f43a14" // 正式环境
#endif
        
    }
    
    struct TencentIMSDKInfo {
        static let customerServiceId = "@customer_service_account"
        static let sdkAppID: Int32 = 1600085314
#if DEBUG
        static let certificateId: Int32 = 45360
#elseif TESTENV
        static let certificateId: Int32 = 45361
#else
        static let certificateId: Int32 = 45361
#endif
    }
    
    // MARK: - 通知相关 名称
    class YhNotification {
        // 登录成功
        public static let didLoginSuccessNotifiction = Notification.Name(rawValue: "com.usleep.health.login.success")
        
        // 退出成功
        public static let didLogoutSuccessNotifiction = Notification.Name(rawValue: "com.usleep.health.logout.success")
        
        // token 过期
        public static let tokenInvalidateNotifiction = Notification.Name(rawValue: "com.usleep.health.token.invalidate")
        
        // 首页刷新通知
        public static let refreshHomePageNotifiction = Notification.Name(rawValue: "com.yinhe.homePage.refresh")
        
        // 清空所有未读消息数
        public static let didMarkAllMessagesReadedNotifiction = Notification.Name(rawValue: "com.yinhe.msgPage.readAll")
        
        // 请求消息未读总数通知
        public static let didRequestUnreadMsgTotalCountNotification = Notification.Name(rawValue: "com.yinhe.msgPage.unreadMsgTotal")
        
        // 请求消息未读列表通知
        public static let didRequestUnreadMsgListNotification = Notification.Name(rawValue: "com.yinhe.msgPage.unreadList")
        
        // 请求通知权限通知
        public static let didReqeustNotifyPermissionNotification = Notification.Name(rawValue: "com.yinhe.msgPage.notifyPermission")
        
        // 强制更新通知
        public static let didForceUpgradeNotifiction = Notification.Name(rawValue: "com.yinhe.version.forceUpgrade")
        
        // 刷新证件文件列表通知
        public static let refreshCertificateFileListNotifiction = Notification.Name(rawValue: "com.yinhe.certificate.updateFileList")
        
        // 点击文件清单条目通知
        public static let clickCertificateFileListItemNotifiction = Notification.Name(rawValue: "com.yinhe.certificate.clickFileListItem")
        
        // 点击文件清单空视图返回服务tab页
        public static let didClickFileListBackToServiceTabNotifiction = Notification.Name(rawValue: "com.yinhe.certificate.backToService")
        
        // 调招 社区的会话页
        public static let goMessageVCNotifiction = Notification.Name(rawValue: "com.yinhe.goMessageVCNotifiction")
        
        // 跳转 社区的活动页
        public static let goActivityVCNotifiction = Notification.Name(rawValue: "com.yinhe.goActivityVCNotifiction")
        
        // 跳转 社区的人脉页
        public static let goConnectionVCNotifiction = Notification.Name(rawValue: "com.yinhe.goConnectionVCNotifiction")
        
        // 点击了 首页的消息
        public static let  clickHomeMsgNotifiction = Notification.Name(rawValue: "com.yinhe.clickHomeMsgNotifiction")
        
        // 接收到消息推送
        public static let didRevMsgNotifiction = Notification.Name(rawValue: "com.yinhe.didRevMsgNotifiction")
        
        // 去看一看点击后开始匹配用户
        public static let didLookPeopleSuccessNotifiction = Notification.Name(rawValue: "com.yinhe.look.people.success")
        
        // 改变底部tabbar上 分享View的展示状态
        public static let changeShareViewStatusOnTabBarNotifiction = Notification.Name(rawValue: "com.yinhe.change.shareView.status")
        
        // 七鱼未读消息数量变化
        public static let didQiYuUnReadMsgCountChangeNotification = Notification.Name(rawValue: "com.yinhe.qiyu.unReadMsgCountChange")
        
        // 获取灰度参数
        public static let didRevUatParam = Notification.Name(rawValue: "com.yinhe.didRevUatParam")
        
        // 跳转通知
        // 跳转到首页资讯tab
        public static let didJumpToHomePageNewsTabNotification = Notification.Name(rawValue: "com.yinhe.homePage.news")
        
        // 跳转到首页生活tab
        public static let didJumpToHomePageLifeTabNotification = Notification.Name(rawValue: "com.yinhe.homePage.life")
        
        // 跳转到首页身份tab
        public static let didJumpToHomePageIdentityTabNotification = Notification.Name(rawValue: "com.yinhe.homePage.identity")
        
        // 跳转到首页生活tab - 教育
        public static let didJumpToHomePageLifeEduTabNotification = Notification.Name(rawValue: "com.yinhe.homePage.life.edu")
        
        // 刷新续签预约状态列表
        public static let didUpdateResignAppointStatusList = Notification.Name(rawValue: "com.yinhe.resign.appoint.list.update")
        
        // 我的证件 微信文件上传回调
        public static let didMyCertificateWeChatFileUploadCallBackNotification = Notification.Name(rawValue: "com.yinhe.myCertificate.wechat.fileUpload")
        public static let didMyResignMaterialWeChatFileUploadCallBackNotification = Notification.Name(rawValue: "com.yinhe.resignMaterial.wechat.fileUpload")
        public static let didMySignWeChatFileUploadCallBackNotification = Notification.Name(rawValue: "com.yinhe.sign.wechat.fileUpload")
        // 已经展示银河管家
        public static let didLoadYhManagerNotification = Notification.Name(rawValue: "com.yinhe.didLoadYhManager")
        public static let backToHomeNotification = Notification.Name(rawValue: "com.yinhe.backToHomeNotification")
        // 切换到AI对话tab
        public static let didSwitchToAIChatNotification = Notification.Name(rawValue: "com.yinhe.switchToAIChat")
        
        // 关闭直播间弹出的分享界面
        public static let closeShareUIInLiveRoomNotifiction = Notification.Name(rawValue: "com.yinhe.app.close.share.ui")
        // 跳转到服务Tab 中的 服务进度
        public static let didJumpToServiceProgressNotification = Notification.Name(rawValue: "com.yinhe.service.tab.serviceprogress")
        public static let didJumpToServicePageSwitchIndexNotification = Notification.Name(rawValue: "com.yinhe.service.tab.switch")
        
        // txIM未读消息数量变化
        public static let didTxIMUnReadMsgCountChangeNotification = Notification.Name(rawValue: "com.yinhe.txIM.unReadMsgCountChange")
        // txIM SDK登录成功
        public static let didTxIMLoginSuccessNotifiction = Notification.Name(rawValue: "com.yinhe.txIM.login.success")
    }
}
