//
//  YHDynamicListItem.swift
//  galaxy
//
//  Created by Dufet on 2025/9/30.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHDynamicListModel: SmartCodable {
    var total: Int = 0
    var page: Int = 0
    var pageSize: Int = 0
    var list: [YHDynamicItem] = []
    
    required init() {
        
    }
}

class YHResourceURLs: SmartCodable {
    var name: String = ""
    var url: String = ""
    var type: Int = 0
    
    required init() {
        
    }
}

class YHDynamicItem: SmartCodable {
    
    var id: String = "" // 动态id
    var user_id: String = ""
    var title: String = ""
    var content: String = ""
    var resource_urls: [YHResourceURLs] = []
    var visibility: Int = 0  // 0-未知 1-公开，2-好友可见，3-仅自己可见
    var audit_status: Int = 0  // 0-未知 1-待审核，2-审核通过，3-不通过
    var ai_audit_status: Int = 0  // 0-未知 1-待审核，2-审核通过，3-不通过
    var violation_reason: Int = 0  // 违规原因 0-未知
    var status: Int = 0  // 状态：0-未知 1-上架中 2-已下架
    var violation_remark: String = ""  // 违规详情
    var ai_audit_remark: String = ""  // ai审核依据
    var click_count: Int = 0
    var like_count: Int = 0
    var comment_count: Int = 0
    var favorite_count: Int = 0
    var nickname: String = ""
    var avatar: String = ""
    var position: String = ""
    var release_time: String = ""
    var format_release_time: String = ""
    var created_at: String = ""
    var is_self_posts: Int = 0  // 是否是自己的动态
    
    required init() {
        
    }
}
