//
//  YHAITabBarItem.swift
//  galaxy
//
//  Created by Dufet on 2024/11/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import ESTabBarController_swift
import Lottie

class YHAITabBarItemContentView: ESTabBarItemContentView {
    
    var timer: Timer?
    
    lazy var tipsView: UIView = {
        
        let v = UIView()
        
        let grayView = UIView()
        grayView.backgroundColor = UIColor(hex: 0x000000, alpha: 0.6)
        grayView.layer.cornerRadius = 6.0
        grayView.clipsToBounds = true
        v.addSubview(grayView)
        
        let label = UILabel()
        label.textColor = UIColor.white
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "Hi 我是港小宝，有什么需要帮助的，来找我吧~"
        grayView.addSubview(label)
        
        let arrowImgV = UIImageView(image: UIImage(named: "ai_tab_down_arrow"))
        v.addSubview(arrowImgV)
        
        arrowImgV.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.equalTo(24)
            make.height.equalTo(6)
            make.bottom.equalTo(-4)
        }

        label.snp.makeConstraints { make in
            make.left.equalTo(15)
            make.right.equalTo(-15)
            make.height.equalTo(34)
            make.top.bottom.equalToSuperview()
        }
        
        grayView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalToSuperview()
            make.bottom.equalTo(arrowImgV.snp.top)
        }
        return v
    }()
    
    lazy var bottomTitleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize: 10)
        label.text = "港小宝"
        return label
    }()
    
    lazy var iconImgView: LottieAnimationView! = {
        let lottieView = LottieAnimationView(name: "tab_ai")
        lottieView.loopMode = .loop
        lottieView.contentMode = .scaleAspectFit
        lottieView.play()
        return lottieView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    public required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.removeSubviews()
        self.addSubview(iconImgView)
        self.addSubview(bottomTitleLabel)
        self.addSubview(tipsView)
        
        bottomTitleLabel.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(14)
        }

        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(48.0)
            make.bottom.equalTo(bottomTitleLabel.snp.top)
            make.centerX.equalToSuperview()
        }
        
        tipsView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.bottom.equalTo(iconImgView.snp.top)
        }
        
        startTimer()
    }
    
    func startTimer() {
        // 每隔 1 秒调用 timerFired 方法
        timer = Timer.scheduledTimer(timeInterval: 5.0,
                                     target: self,
                                     selector: #selector(timerFired),
                                     userInfo: nil,
                                     repeats: false)
    }
    
    @objc func timerFired() {
        stopTimer()
        tipsView.isHidden = true
    }
        
    // 停止定时器
    func stopTimer() {
        timer?.invalidate()
        timer = nil
    }
    
    deinit {
        // 确保在视图控制器被销毁时停止定时器
        stopTimer()
    }
}
