//
//  YHFileListContentView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFileListContentView: UIView {
        
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var dataModel: [YHFileListModel?]? {
        didSet {
            updateUI()
        }
    }
}

private extension YHFileListContentView {
    func initView() {
        backgroundColor = .clear
        
    }
}

extension YHFileListContentView {
    func updateUI() {
        guard let arrData = dataModel, arrData.count > 0 else { return }
        
        removeSubviews()
        
        let sessionBkgImageV: UIImageView = UIImageView(image: UIImage(named: "file_list_head_bkg"))
        sessionBkgImageV.contentMode = .scaleAspectFill
        
        sessionBkgImageV.clipsToBounds = true
        sessionBkgImageV.roundCorners([.topLeft, .topRight], radius: kCornerRadius12)
//        sessionBkgImageV.roundCorners(.topRight, radius: kCornerRadius12)
        
        addSubview(sessionBkgImageV)
        if arrData.isEmpty {
            sessionBkgImageV.snp.makeConstraints { make in
                make.top.equalToSuperview().offset(2)
                make.left.equalToSuperview().offset(2)
                make.right.equalToSuperview().offset(-2)
                make.height.equalTo(70)
                
                make.bottom.equalToSuperview().offset(-20)
            }
            
        } else {
            sessionBkgImageV.snp.makeConstraints { make in
                make.top.equalToSuperview().offset(2)
                make.left.equalToSuperview().offset(2)
                make.right.equalToSuperview().offset(-2)
                make.height.equalTo(70)
            }
        }
        
        sessionBkgImageV.layoutIfNeeded()
        
        var lastView: UIView?
        for (index, item) in arrData.enumerated() {
            if let iii = item {
                var view: UIView = YHFileListItemsView()
                if iii.type == 0 {
                    if let view = view as? YHFileListItemsView {
                        view.dataModel = item
                    }
                } else {
                    // if item?.type == 1
                    view = YHFileListItemsView2()
                    if let view = view as? YHFileListItemsView2 {
                        view.dataModel = item
                    }
                }
                addSubview(view)
                
                if let tttttt = lastView {
                    if index == arrData.count - 1 {
                        view.snp.makeConstraints { make in
                            make.top.equalTo(tttttt.snp.bottom)
                            make.left.right.equalToSuperview()
                            make.bottom.equalToSuperview().offset(-20)
                        }
                    } else {
                        view.snp.makeConstraints { make in
                            make.top.equalTo(tttttt.snp.bottom)
                            make.left.right.equalToSuperview()
                        }
                    }
                } else {
                    if index == arrData.count - 1 {
                        view.snp.makeConstraints { make in
                            make.top.equalToSuperview()
                            make.left.right.equalToSuperview()
                            make.bottom.equalToSuperview().offset(-20)
                        }
                    } else {
                        view.snp.makeConstraints { make in
                            make.top.equalToSuperview()
                            make.left.right.equalToSuperview()
                        }
                    }
                }
                lastView = view
            }
        }
    }
}
