//
//  YHMemberCenterFooterView.swift
//  galaxy
//
//  Created by alexzzw on 2025/2/18.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMemberCenterFooterView: UIView {
    private static let iconWidth = 127.0
    private static let iconHeight = 48.0

    static var viewHeight: CGFloat {
        return iconHeight + 42 * 2
    }

    private lazy var leftLineView: UIView = {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth / 2.0, height: 1))
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()

    private lazy var rightLineView: UIView = {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth / 2.0, height: 1))
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()

    private lazy var contentIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "member_center_brand")
        return view
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    private func setupUI() {
        addSubview(contentIcon)
        addSubview(leftLineView)
        addSubview(rightLineView)
        contentIcon.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(YHMemberCenterFooterView.iconWidth)
            make.height.equalTo(YHMemberCenterFooterView.iconHeight)
        }

        leftLineView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(24)
            make.right.equalTo(contentIcon.snp.left).offset(-12)
            make.centerY.equalTo(contentIcon)
            make.height.equalTo(1)
        }

        rightLineView.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-24)
            make.left.equalTo(contentIcon.snp.right).offset(12)
            make.centerY.equalTo(contentIcon)
            make.height.equalTo(1)
        }
    }
}
