//
//  YHMySectionGroupItemCellCollectionViewCell.swift
//  galaxy
//
//  Created by Dufet on 2025/2/13.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyFunctionGroupItemCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHMyFunctionGroupItemCell"
    
    func updateItem(_ item: PersonalModuleItem) {
        titleLabel.text = item.title
        redPointView.isHidden = !item.isShowRedPoint
        if let icon = item.icon, !icon.isEmpty {
            iconImgView.image = UIImage(named: icon)
        } else {
            iconImgView.image = nil
        }
    }

    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize: 12)
        return label
    }()
    
    lazy var iconImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: ""))
        return v
    }()
    
    private lazy var redPointView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = 2.5
        view.clipsToBounds = true
        view.backgroundColor = .failColor
        view.isHidden = true
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    func setupUI() {
        self.contentView.addSubview(titleLabel)
        self.contentView.addSubview(iconImgView)
        self.contentView.addSubview(redPointView)
        
        iconImgView.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.width.height.equalTo(24)
            make.centerX.equalToSuperview()
        }
        
        redPointView.snp.makeConstraints { make in
            make.width.height.equalTo(5)
            make.top.equalTo(iconImgView)
            make.left.equalTo(iconImgView.snp.right).offset(0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgView.snp.bottom).offset(8)
            make.height.equalTo(18)
            make.left.right.equalToSuperview()
        }
    }
}
