//
//  YHSurveySubmitDoneViewController.swift
//  galaxy
//
//  Created by alexzzw on 2025/3/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSurveySubmitDoneViewController: YHBaseViewController {
    private lazy var topImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "plan_question_submitted")
        return view
    }()

    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.text = "问卷提交成功"
        label.textColor = .mainTextColor
        label.font = .PFSC_B(ofSize: 17)
        label.textAlignment = .center
        return label
    }()

    private lazy var infoContentLabel: UILabel = {
        let label = UILabel()
        label.text = "专属顾问将在24小时内与您联系，\n为您提供详细方案"
        label.textColor = UIColor(hex: 0x6A7586)
        label.font = .PFSC_R(ofSize: 14)
        label.textAlignment = .center
        label.numberOfLines = 0
        return label
    }()

    private lazy var backHomeButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitle("返回首页", for: .normal)
        button.addTarget(self, action: #selector(backHomeClicked), for: .touchUpInside)
        button.backgroundColor = .mainTextColor
        button.setTitleColor(.white, for: .normal)
        button.titleLabel?.font = .PFSC_R(ofSize: 14)
        button.layer.cornerRadius = 3
        button.clipsToBounds = true
        return button
    }()
    
    override func backItemClick(_ sender: Any) {
        backEvent()
    }

    /// 是否可以返回，包括点击返回和手势返回，默认YES
    override func navigationShouldPop() -> Bool {
        backEvent()
        return false
    }
    
    private func backEvent() {
        navigationController?.popToRootViewController(animated: true)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }

    private func setupUI() {
        gk_navTitle = "香港身份方案评估"
        gk_navBarAlpha = 1.0
        gk_navBackgroundColor = .white

        view.backgroundColor = UIColor.white
        view.addSubview(topImageView)
        view.addSubview(infoTitleLabel)
        view.addSubview(infoContentLabel)
        view.addSubview(backHomeButton)
        topImageView.snp.makeConstraints { make in
            make.width.equalTo(127)
            make.height.equalTo(127)
            make.top.equalToSuperview().offset(129 + k_Height_NavigationtBarAndStatuBar)
            make.centerX.equalToSuperview()
        }
        infoTitleLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(topImageView.snp.bottom).offset(8)
        }
        infoContentLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(8)
            make.left.greaterThanOrEqualToSuperview().offset(16)
            make.right.lessThanOrEqualToSuperview().offset(-16)
        }
        backHomeButton.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(infoContentLabel.snp.bottom).offset(24)
            make.width.equalTo(100)
            make.height.equalTo(40)
        }
    }

    @objc private func backHomeClicked() {
        UIViewController.current?.navigationController?.popToRootViewController(animated: false)
        goTabBarBy(tabType: .home)
    }
}
