//
//  YHCirclePublishViewController.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/24.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCirclePublishViewController: YHBaseViewController {
    
    var completion: (() -> Void)?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        gk_navigationBar.isHidden = true
        title = "发布动态"
        
        navigationItem.leftBarButtonItem = UIBarButtonItem(
            title: "取消",
            style: .plain,
            target: self,
            action: #selector(cancelButtonTapped)
        )
        
        navigationItem.rightBarButtonItem = UIBarButtonItem(
            title: "发布",
            style: .done,
            target: self,
            action: #selector(publishButtonTapped)
        )
        
        let label = UILabel()
        label.text = "发布页面"
        label.textAlignment = .center
        label.textColor = .gray
        view.addSubview(label)
        
        label.snp.makeConstraints { make in
            make.center.equalToSuperview()
        }
    }
    
    @objc private func cancelButtonTapped() {
        dismiss(animated: true)
    }
    
    @objc private func publishButtonTapped() {
        completion?()
        dismiss(animated: true)
    }
}
