//
//  YHIncomeRecordFromCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeRecordFromCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHIncomeRecordFromCell"
    private lazy var dotIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "red_dot_6"))
        return imageView
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "收入来源公司"
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.numberOfLines = 0
        label.lineBreakMode = .byWordWrapping
        return label
    }()
    
    private lazy var rightArrowIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imageView
    }()
    
    private lazy var infoFailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .failColor
        label.text = "请选择"
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: String?, showBottomLine: Bool = true, showRightArrow: Bool = false, placeholder: String = "", needShowFailButton: Bool = false) {
        infoTitleLabel.text = title
        if let detail = detail, detail.count > 0 {
            infoDetailLabel.text = detail
            infoDetailLabel.font = .PFSC_M(ofSize: 14)
            infoDetailLabel.textColor = UIColor.mainTextColor
        } else {
            infoDetailLabel.text = placeholder
            infoDetailLabel.font = .PFSC_R(ofSize: 14)
            infoDetailLabel.textColor = UIColor(hexString: "#B9C1CC")
        }
        bottomLineView.isHidden = !showBottomLine
        rightArrowIcon.isHidden  = !showRightArrow
        updateFailLabel(needShowFailButton)
    }
}

extension YHIncomeRecordFromCell {
    private func updateFailLabel(_ needShowFailButton: Bool) {
        if needShowFailButton {
            infoFailLabel.snp.remakeConstraints { make in
                make.top.equalTo(infoTitleLabel.snp.bottom).offset(6)
                make.left.equalTo(dotIcon)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
            infoFailLabel.isHidden = false
        } else {
            infoFailLabel.snp.remakeConstraints { make in
                make.left.equalTo(dotIcon)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
            infoFailLabel.isHidden = true
        }
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(dotIcon)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(rightArrowIcon)
        subContainerView.addSubview(bottomLineView)
        subContainerView.addSubview(infoFailLabel)
        
        dotIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightArrowIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        dotIcon.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.width.height.equalTo(6)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(dotIcon.snp.right).offset(2)
        }
        
        rightArrowIcon.snp.makeConstraints { make in
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
            make.width.height.equalTo(20)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.greaterThanOrEqualToSuperview().offset(16)
            make.bottom.lessThanOrEqualToSuperview().offset(-16)
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(147)
            make.right.lessThanOrEqualTo(rightArrowIcon.snp.left).offset(-18)
        }
        
        infoFailLabel.snp.makeConstraints { make in
            make.left.equalTo(dotIcon)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-16)
        }
        infoFailLabel.isHidden = true
        
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
        }
    }
}
