//
//  YHSurveySubmitRequestModel.swift
//  galaxy
//
//  Created by alexzzw on 2025/3/31.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

// MARK: - YHSurveySubmitRequestModel

class YHSurveySubmitRequestModel {
    /// 答案详情
    var answerDetails: [YHSurveyArticleAnswerItem] = []
    /// 问卷id
    var surveyId: String = ""

    init(answerDetails: [YHSurveyArticleAnswerItem], surveyId: String) {
        self.answerDetails = answerDetails
        self.surveyId = surveyId
    }
}

// MARK: - YHSurveyArticleAnswerItem

class YHSurveyArticleAnswerItem {
    /// 文件列表 仅对文件上传题有效且必需
    var fileList: [YHSurveyAnswerItemFileItem] = []
    /// 选中的选项ID与额外说明 仅对单选/多选有效且必需，单选时此项长度为1
    var optionExtra: [YHSurveyAnswerItemOptionExtra] = []
    /// 问题ID 必需
    var questionId: String = ""
    /// 问题key 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var questionKey: String = ""
    /// 问题类型：1:单选 2:多选 3:文本输入 4:文件上传 必需
    var questionType: Int = 0
    /// 文本输入内容 仅对文本输入题有效且必需
    var text: String = ""
    /// 问题标题 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var title: String = ""

    init(fileList: [YHSurveyAnswerItemFileItem], optionExtra: [YHSurveyAnswerItemOptionExtra], questionId: String, questionKey: String, questionType: Int, text: String, title: String) {
        self.fileList = fileList
        self.optionExtra = optionExtra
        self.questionId = questionId
        self.questionKey = questionKey
        self.questionType = questionType
        self.text = text
        self.title = title
    }
}

// MARK: - YHSurveyAnswerItemFileItem

class YHSurveyAnswerItemFileItem {
    /// 文件名称 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var name: String = ""
    /// 文件大小 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var size: Int = 0
    /// 文件类型 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var type: String = ""
    /// 上传时间(格式:YYYY-MM-DD HH:mm:ss) 可选 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var uploadAt: String = ""
    /// 文件url 必需
    var url: String = ""

    init(name: String, size: Int, type: String, uploadAt: String, url: String) {
        self.name = name
        self.size = size
        self.type = type
        self.uploadAt = uploadAt
        self.url = url
    }
}

// MARK: - YHSurveyAnswerItemOptionExtra

class YHSurveyAnswerItemOptionExtra {
    /// 问题选项额外说明 选中该选项后必需填写额外说明时必需
    var extra: String = ""
    /// 选项ID 必需
    var optionId: String = ""
    /// 选项key 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var optionKey: String = ""
    /// 选项标题 可选 提交答案时，建议设置该字段，会作为提交记录留底；show_when场景下，忽略该字段
    var title: String = ""

    init(extra: String, optionId: String, optionKey: String, title: String) {
        self.extra = extra
        self.optionId = optionId
        self.optionKey = optionKey
        self.title = title
    }
}
