//
//  YHLookResignResultModel.swift
//  galaxy
//
//  Created by EDY on 2024/10/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHLookResignResultModel: SmartCodable {
    
    var status: Int = 0      // 续签状态: 1: 待递交 2：审核中 3：待补件 4：已获批
    var statusText: String = ""
    var mode: Int = 0      // 续签状态: 1: 个人 2：家庭
    var data: YHLookResignResultDataModel = YHLookResignResultDataModel()

    required init() {
    }
}

class YHLookResignResultDataModel: SmartCodable {
    
    var data: [YHLookResignResultDataDataModel] = []      // 人员
    var user: String = ""  // 主申请人信息
    var deadline: String = ""
    var result_file: String = ""
    var letters: [YHLookResignResultDataLettersModel] = []
    var main: YHLookResignResultDataMainModel = YHLookResignResultDataMainModel()
    
    required init() {
    }
}

class YHLookResignResultDataDataModel: SmartCodable {
    
    var number: Int = 0
    var pay_deadline: String = ""
    var result_date: String = ""
    var users: [String] = []
    var result_file: String = ""
    
    required init() {
    }
}

class YHLookResignResultDataLettersModel: SmartCodable {
    
    var user: String = ""  // 人信息
    var result_file: String = ""
    var confirm_in_hk: Int = 0
    required init() {
    }
}

class YHLookResignResultDataMainModel: SmartCodable {
    
    var pay_deadline: String = ""
    var result_date: String = ""

    required init() {
    }
}
