//
//  YHResignAppointShowTimeItemView.swift
//  galaxy
//
//  Created by edy on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignAppointShowTimeItemView: UIView {

    var title: String = "" {
        didSet {
            titleLabel.text = title
        }
    }
    
    var detail: String = "" {
        didSet {
            var text = detail
            if text.isEmpty {
                text = " " // 空字符串不能自适应label高度
            }
            detailLabel.text = text
        }
    }
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor(alpha: 0.5)
        return label
    }()
    
    private lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        label.textAlignment = .right
        label.text = "0000-00-00 00:00"
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(titleLabel)
        self.addSubview(detailLabel)
        self.addSubview(lineView)
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(0)
            make.height.equalTo(0.5)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(16)
            make.width.equalTo(112)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(titleLabel.snp.right).offset(18.0)
            make.right.equalTo(0)
            make.bottom.equalTo(-16)
        }
        
    }

}
