//
//  YHPrincipleSendMailView.swift
//  galaxy
//
//  Created by edy on 2024/8/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift

class YHPrincipleSendMailView: UIView {

    var confirmBlock: ((String) -> Void)?
    
    static func mailView() -> YHPrincipleSendMailView {
        let view = YHPrincipleSendMailView(frame: UIScreen.main.bounds)
        return view
    }
    
    func show() {
        addKeyBoardNotify()
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
        emailInputView.textField.becomeFirstResponder()
    }
    
    func dismiss() {
        removeNotify()
        self.removeFromSuperview()
    }

    lazy var emailInputView: YHEmailInputAlertView = {
        let view = YHEmailInputAlertView.emailInputView(defalutText: "")
        view.textField.attributedPlaceholder = NSAttributedString(string: "请输入邮箱".local, attributes: [NSAttributedString.Key.foregroundColor: UIColor.placeHolderColor])
        return view
    }()
    
    // 底层蒙版
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    deinit {
        self.removeNotify()
    }
    
    func createUI() {
        
        self.addSubview(self.blackMaskView)
        self.addSubview(self.emailInputView)
        self.emailInputView.dismissBlock = {
            [weak self] in
            guard let self = self else { return }
            self.dismiss()
        }
        self.emailInputView.editBlock = {
            [weak self] text in
            guard let self = self else { return }
            if let text = text {
                confirmBlock?(text)
            }
        }
        self.blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        self.emailInputView.snp.updateConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(YHFileRenameInputView.height)
            make.bottom.equalToSuperview().offset(YHFileRenameInputView.height)
        }
    }
    
    func addKeyBoardNotify() {
        
        NotificationCenter.default.addObserver(self, selector: #selector(handleKeyboardNotification(_:)), name: UIResponder.keyboardWillShowNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(handleKeyboardNotification(_:)), name: UIResponder.keyboardWillHideNotification, object: nil)
    }
    
    func removeNotify() {
        NotificationCenter.default.removeObserver(self)
    }
    
    @objc func handleKeyboardNotification(_ notification: Notification) {
        
        if notification.userInfo != nil {
            
            guard let keyboardFrame = (notification.userInfo?[UIResponder.keyboardFrameEndUserInfoKey] as AnyObject).cgRectValue else {return }
            
            let isKeyboardShow = notification.name == UIResponder.keyboardWillShowNotification
            let bottomMargin = (isKeyboardShow ? -keyboardFrame.height : YHFileRenameInputView.height)
            
            if !isKeyboardShow {
                IQKeyboardManager.shared.isEnabled = true
            }
            
            self.emailInputView.snp.updateConstraints { make in
                make.bottom.equalToSuperview().offset(bottomMargin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
            if !isKeyboardShow {
                self.dismiss()
            }
        }
    }

}
