//
//  YHResignCertificateListViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/9/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignCertificateListViewModel: YHBaseViewModel {
    var mainModel: YHResignCertificateMainModel = YHResignCertificateMainModel()
    
    func getResignCertificateList(orderId: Int, batchId: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let param = ["orderId": orderId,
                     "renewal_id": batchId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignCertificate.resignCertificateList
        _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let data = dic["data"] as? [String: Any], let result = YHResignCertificateMainModel.deserialize(from: data) else {
                    callBackBlock(false, nil)
                    return
                }
                self?.mainModel = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
