//
//  YHGCSignatureUploadTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/12/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCSignatureUploadTableViewCell: UITableViewCell {
    typealias Block = (YHMyFileMethodType, Int) -> Void
    var block: Block?
    var centerView: UIView!
    var titleLabel: UILabel!
    var topLineView: UIView!
    var promptLabel: UILabel!
    var mainItemView: UIView!
    var downLoadButton: UIButton!
    var bottomView: YHWorkItemAddView!

    var dataSource: YHMySignatureDetailModel? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        let width = (KScreenWidth - 32)/3.0
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "上传已签章件"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        downLoadButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("下载待签署文件", for: .normal)
            button.addTarget(self, action: #selector(downLoadClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        centerView.addSubview(downLoadButton)
        downLoadButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.centerY.equalTo(titleLabel.snp.centerY)
            make.width.equalTo(98)
            make.height.equalTo(20)
        }
        
        promptLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.labelTextColor2
            label.numberOfLines = 0
            label.text = "注意：1.支持PDF、JPEG、JPG、PNG、BMP、TIFF文件格式，文件大小不限制；2.上传成功后会自动更新文件名；3.最多上传10张图片或文件，若有问题可联系文案"
            return label
        }()
        centerView.addSubview(promptLabel)
        promptLabel.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.left.equalTo(16)
            make.height.equalTo(60)
            make.bottom.equalTo(-16)
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("上传已签章件".local, for: .normal)
            view.addBtn.setImage(UIImage(named: "document_upload"), for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.block {
                    block(.upload, 0)
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.bottom.equalTo(-92)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(45)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-153)
            make.top.equalTo(52)
        }
        
        let line = UIView()
        line.backgroundColor = UIColor.separatorColor
        centerView.addSubview(line)
        line.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
    }
    
    @objc func downLoadClick() {
        if let block = block {
            block(.downLoad, 0)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        mainItemView.removeSubviews()
        if dataSource.doc_return_manual.count != 0 {
            bottomView.addBtn.setTitle("继续上传".local, for: .normal)
        } else {
            bottomView.addBtn.setTitle("上传已签章件".local, for: .normal)
        }
        
        if dataSource.docStatus == 1000 || dataSource.docStatus == 1001 {
            downLoadButton.isHidden = false
        } else if dataSource.docStatus == 1002 {
            downLoadButton.isHidden = false
        } else if dataSource.docStatus == 1003 {
            downLoadButton.isHidden = false
        } else if dataSource.docStatus == 1004 {
            downLoadButton.isHidden = true
        } else if dataSource.docStatus == 1005 {
            downLoadButton.isHidden = true
        } else if dataSource.docStatus == 1006 {
            downLoadButton.isHidden = true
        } else if dataSource.docStatus == 1007 {
            downLoadButton.isHidden = true
        }
        
        if dataSource.docType == 1001 {
            downLoadButton.setTitle("下载待签章文件", for: .normal)
            bottomView.addBtn.setTitle("上传已签章件".local, for: .normal)
            titleLabel.text = "上传已签章件"
        } else {
            downLoadButton.setTitle("下载待签署文件", for: .normal)
            bottomView.addBtn.setTitle("上传已签署件".local, for: .normal)
            titleLabel.text = "上传已签署件"
        }
        
        var y = 0
        for i in 0 ..< (dataSource.signedDocument.count) {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            y += 1
            let data = dataSource.signedDocument[i]
            let h = 70
            let itemView = YHDocumentFileItemView()
            itemView.index = i
            itemView.type = dataSource.docStatus
            itemView.docDataSource = data
            itemView.itemBlock = {[weak self] type, index in
                guard let self = self else { return }
                if let block = block {
                    block(type, index)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(h)
                make.right.equalTo(-18)
            }
            y += h
        }
        updateAddView()
    }
    
    func updateAddView() {
        guard let dataSource = dataSource else { return }
        
        if dataSource.docStatus == 1007 || dataSource.docStatus == 1006 || dataSource.docStatus == 1004 || dataSource.docStatus == 1005 {
            self.bottomView.isHidden = true
            mainItemView.snp.remakeConstraints { make in
                make.left.right.equalToSuperview()
                make.bottom.equalTo(-92)
                make.top.equalTo(52)
            }
        }
    }
}
