//
//  YHImageViewController.swift
//  galaxy
//
//  Created by EDY on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHImageViewController: YHBaseViewController {
    var resultView: UIImageView!
    var resultButton: UIButton!
    var imgString: String!
    var viewModel: YHBaseViewModel!

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .black
        viewModel = YHWorkExperienceViewModel()
        setView()
        getData()
    }

    func setView() {
        resultView = {
            let step = UIImageView()
            step.contentMode = .scaleAspectFit
            return step
        }()
        view.addSubview(resultView)
        resultView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.equalTo(view)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 54)
        }
        
        resultButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(back), for: .touchUpInside)
            return button
        }()
        view.addSubview(resultButton)
        resultButton.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.equalTo(view)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 54)
        }
    }
    
    @objc func back() {
        self.navigationController?.popViewController()
    }
    
    func getData() {
        self.viewModel.getPublicImageUrl(imgString) {[weak self] success, error in
            guard let self = self else { return }
            
            if success == nil {
                let msg = error?.errorMsg ?? "出现错误"
                YHHUD.flash(message: msg)
                DispatchQueue.main.asyncAfter(deadline: .now() + 1) {
                    self.back()
                }
            }
            self.resultView.kf.setImage(with: URL(string: success), placeholder: UIImage(named: "global_default_image"))
        }
    }
}
