//
//  YHMemberCenterCurrentPrivilegeCell.swift
//  galaxy
//
//  Created by alexzzw on 2025/2/17.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMemberCenterCurrentPrivilegeCell: UITableViewCell {
    static let cellReuseIdentifier = "YHMemberCenterCurrentPrivilegeCell"

    private lazy var leftLineView: UIView = {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth / 2.0, height: 1))
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()

    private lazy var rightLineView: UIView = {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth / 2.0, height: 1))
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()

    private lazy var leftIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "member_privilege_lock")
        return view
    }()

    private lazy var rightIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "member_privilege_right")
        return view
    }()

    private lazy var midLabel: UILabel = {
        let label = UILabel()
        label.text = "xx会员拥有特权x项"
        label.textColor = UIColor(hexString: "#B9C1CC")
        label.font = .PFSC_M(ofSize: 13)
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    func setupCell(mid: String, isOverLevel: Bool) {
        midLabel.text = mid
        leftIcon.isHidden = isOverLevel
        if isOverLevel {
            leftLineView.snp.remakeConstraints { make in
                make.right.equalTo(midLabel.snp.left).offset(-8)
                make.height.equalTo(1)
                make.left.equalToSuperview().offset(25)
            }
        } else {
            leftLineView.snp.remakeConstraints { make in
                make.right.equalTo(leftIcon.snp.left).offset(-8)
                make.height.equalTo(1)
                make.left.equalToSuperview().offset(25)
            }
        }
    }

    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(leftLineView)
        contentView.addSubview(rightLineView)
        contentView.addSubview(leftIcon)
        contentView.addSubview(rightIcon)
        contentView.addSubview(midLabel)
        midLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        leftIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        rightIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        leftLineView.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightLineView.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)

        midLabel.snp.makeConstraints { make in
            make.center.equalToSuperview()
        }

        leftIcon.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(midLabel.snp.left).offset(-2)
            make.width.height.equalTo(16)
        }

        rightIcon.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(midLabel.snp.right).offset(2)
            make.width.height.equalTo(16)
        }

        leftLineView.snp.makeConstraints { make in
            make.right.equalTo(leftIcon.snp.left).offset(-8)
            make.height.equalTo(1)
            make.left.equalToSuperview().offset(25)
        }

        rightLineView.snp.makeConstraints { make in
            make.left.equalTo(rightIcon.snp.left).offset(8)
            make.height.equalTo(1)
            make.right.equalToSuperview().offset(-25)
        }
    }
}
