//
//  YHUserVipInfoView.swift
//  galaxy
//
//  Created by Dufet on 2025/2/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHUserVipLevel: Int {
    case none = 0
    case gold = 1
    case platinum = 2
    case diamond = 3
}

class YHUserVipFunctionInfoView: UIView {
    
    var title: String = "" {
        didSet {
            titleLabel.text = title
        }
    }
    
    var desc: String = "" {
        didSet {
            descLabel.text = desc
        }
    }
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .white
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        return label
    }()
    
    lazy var descLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor(hex: 0xFFFFFF, alpha: 0.6)
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 10)
        return label
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0xFFFFFF, alpha: 0.16)
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.clipsToBounds = true
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func update(title: String, desc: String, titleColor: UIColor, descColor: UIColor) {
        titleLabel.text = title
        titleLabel.textColor = titleColor
        descLabel.text = desc
        descLabel.textColor = descColor
    }
    
    private func createUI() {
        
        self.addSubview(lineView)
        self.addSubview(titleLabel)
        self.addSubview(descLabel)
        
        lineView.snp.makeConstraints { make in
            make.width.equalTo(1)
            make.height.equalTo(33)
            make.left.equalTo(0)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-5)
            make.top.equalTo(12)
            make.height.equalTo(17)
        }
        
        descLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-5)
            make.top.equalTo(titleLabel.snp.bottom).offset(2)
            make.height.equalTo(14)
        }
    }
}

class YHUserVipInfoView: UIView {
    
    var clickEvent: (() -> Void)?

    var growValue: Int = 0
    var vipLevel: YHUserVipLevel = .none {
        didSet {
            updateVipLevel(vipLevel)
        }
    }
    
    lazy var bgImgView: UIImageView = {
        let imgV = UIImageView()
        imgV.image = UIImage(named: "mine_member_bg_vip_0")
        return imgV
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "普通会员"
        label.textColor = .white
        label.textAlignment = .left
        label.font = UIFont.PFSC_B(ofSize: 17)
        return label
    }()
    
    lazy var growValueLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .left
        return label
    }()
    
    lazy var function1View: YHUserVipFunctionInfoView = {
        let v = YHUserVipFunctionInfoView(frame: .zero)
        v.lineView.isHidden = true
        v.title = "舒适出行"
        v.desc = "深港专车服务"
        return v
    }()
    
    lazy var function2View: YHUserVipFunctionInfoView = {
        let v = YHUserVipFunctionInfoView(frame: .zero)
        v.title = "奢华会客"
        v.desc = "北上深港体验中心"
        return v
    }()
    
    lazy var function3View: YHUserVipFunctionInfoView = {
        let v = YHUserVipFunctionInfoView(frame: .zero)
        v.title = "高端私董会"
        v.desc = "打造高端人脉圈子"
        return v
    }()
    
    lazy var rightBtn: UIButton = {
        let btn = UIButton()
        btn.backgroundColor = .init(hex: 0x323849)
        btn.titleLabel?.font = .PFSC_M(ofSize: 10)
        btn.setTitle("更多权益", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.layer.cornerRadius = 15.0
        btn.isUserInteractionEnabled = false
//        btn.addTarget(self, action: #selector(rightButtonClicked), for: .touchUpInside)
        return btn
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.clipsToBounds = true
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func createUI() {
        
        self.addSubview(bgImgView)
        self.addSubview(titleLabel)
        self.addSubview(growValueLabel)
        self.addSubview(rightBtn)

        self.addSubview(function1View)
        self.addSubview(function2View)
        self.addSubview(function3View)
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(rightButtonClicked))
        self.addGestureRecognizer(tap)

        bgImgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.bottom.equalTo(self.snp.centerY).offset(-16)
            make.left.equalTo(16)
            make.height.equalTo(24)
            make.width.equalTo(68)
        }
        
        growValueLabel.snp.makeConstraints { make in
            make.centerY.equalTo(titleLabel)
            make.left.equalTo(titleLabel.snp.right).offset(4)
            make.height.equalTo(17)
            make.right.equalTo(rightBtn.snp.left).offset(-16)
        }
        
        rightBtn.snp.makeConstraints { make in
            make.height.equalTo(30)
            make.width.equalTo(72)
            make.centerY.equalTo(titleLabel)
            make.right.equalTo(-16)
        }

        function1View.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(self.snp.centerY)
            make.bottom.equalTo(0)
            make.width.equalTo(function2View)
        }
        
        function2View.snp.makeConstraints { make in
            make.left.equalTo(function1View.snp.right)
            make.top.equalTo(function1View)
            make.bottom.equalTo(0)
            make.width.equalTo(function3View)
        }
        
        function3View.snp.makeConstraints { make in
            make.left.equalTo(function2View.snp.right)
            make.right.equalTo(0)
            make.top.equalTo(function1View)
            make.bottom.equalTo(0)
        }
        
        self.update(growValue: 0, vipLevel: .none)
    }
    
    @objc func rightButtonClicked() {
        clickEvent?()
    }
    
    func updateVipLevel(_ vipLevel: YHUserVipLevel) {
        
        if vipLevel == .gold {
            self.bgImgView.image = UIImage(named: "mine_member_bg_vip_1")
            self.titleLabel.text = "黄金会员"
            self.titleLabel.textColor = .white
            self.rightBtn.backgroundColor = UIColor(hex: 0x5A2C0E)
            self.rightBtn.setTitleColor(.white, for: .normal)
            function1View.update(title: "专属顾问", desc: "8小时*5天专人", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
            function2View.update(title: "专属积分", desc: "消费累积享好礼", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
            function3View.update(title: "奢华会客厅", desc: "体验中心使用权", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
            
        } else if vipLevel == .platinum {
            self.bgImgView.image = UIImage(named: "mine_member_bg_vip_2")
            self.titleLabel.text = "铂金会员"
            self.titleLabel.textColor = .white
            self.rightBtn.backgroundColor = UIColor(hex: 0x382F6B)
            self.rightBtn.setTitleColor(.white, for: .normal)
            function1View.update(title: "专属顾问", desc: "12小时*7天专人", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
            function2View.update(title: "奢华会客厅", desc: "体验中心使用权", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
            function3View.update(title: "专属中港车", desc: "专车接送服务", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
            
        } else if vipLevel == .diamond {
            self.bgImgView.image = UIImage(named: "mine_member_bg_vip_3")
            self.titleLabel.text = "钻石会员"
            self.titleLabel.textColor = .init(hex: 0xE0C9AF)
            self.rightBtn.backgroundColor = UIColor(hex: 0xE0C9AF)
            self.rightBtn.setTitleColor(.init(hex: 0x12296F), for: .normal)
            function1View.update(title: "专属顾问", desc: "24小时*7天专人", titleColor: UIColor(hex: 0xE0C9AF), descColor: UIColor(hex: 0xE0C9AF, alpha: 0.6))
            function2View.update(title: "专属中港车", desc: "专车接送服务", titleColor: UIColor(hex: 0xE0C9AF), descColor: UIColor(hex: 0xE0C9AF, alpha: 0.6))
            function3View.update(title: "高端私董会", desc: "共享商业洞见", titleColor: UIColor(hex: 0xE0C9AF), descColor: UIColor(hex: 0xE0C9AF, alpha: 0.6))
            
        } else {
            self.bgImgView.image = UIImage(named: "mine_member_bg_vip_0")
            self.titleLabel.text = "普通会员"
            self.titleLabel.textColor = .white
            self.rightBtn.backgroundColor = UIColor(hex: 0x323849)
            self.rightBtn.setTitleColor(.white, for: .normal)
            function1View.update(title: "AI港小宝", desc: "聚焦香港的智能体", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
            function2View.update(title: "专属积分", desc: "消费累积享好礼", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
            function3View.update(title: "精品下午茶", desc: "尊享精致茶点", titleColor: .white, descColor: UIColor(hex: 0xFFFFFF, alpha: 0.6))
        }
    }
    
    func update(growValue: Int, vipLevel: YHUserVipLevel) {
        
        self.growValue = growValue
        self.vipLevel = vipLevel

        let text = "当前成长值"
        let count = " \(growValue)"
        
        var textColor = UIColor(hex: 0xFFFFFF, alpha: 0.6)
        if vipLevel == .diamond {
            textColor = UIColor(hex: 0xE0C9AF, alpha: 0.6)
        }
        
        let attrStr = NSMutableAttributedString(string: "")
        
        let countAttrStr = NSAttributedString(
                                    string: count,
                                    attributes: [NSAttributedString.Key.foregroundColor: textColor,
                                                 NSAttributedString.Key.font: UIFont(name: "DINAlternate-Bold", size: 13)!])
        let titleAttrStr = NSAttributedString(
                                    string: text,
                                    attributes: [NSAttributedString.Key.foregroundColor: textColor,
                                                 NSAttributedString.Key.font: UIFont.PFSC_R(ofSize: 12)])
        attrStr.append(titleAttrStr)
        attrStr.append(countAttrStr)
        growValueLabel.attributedText = attrStr
    }
}
