//
//  YHCardButton.swift
//  galaxy
//
//  Created by EDY on 2024/3/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCardButton: UIButton {

    var topImageView: UIImageView!
    var bottomTitleLabel: UILabel!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        topImageView = {
            let view = UIImageView()
            return view
        }()
        addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(22)
            make.width.height.equalTo(24)
        }
        
        bottomTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 12)
            label.textAlignment = .center
            label.textColor = UIColor.brandMainColor
            return label
        }()
        addSubview(bottomTitleLabel)
        bottomTitleLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(20)
            make.bottom.equalTo(-15)
        }
    }
    
    func setContent(_ image: String, _ title: String) {
        topImageView.removeFromSuperview()
        topImageView = nil
        topImageView = {
            let view = UIImageView()
            return view
        }()
        addSubview(topImageView)
        topImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(22)
            make.width.height.equalTo(24)
        }
        bottomTitleLabel.text = title
        topImageView.image = UIImage(named: image)
    }
    
    // 开始旋转动画的函数
    func startRotationAnimation() {
        let rotationAnimation = CAKeyframeAnimation(keyPath: "transform.rotation")
        rotationAnimation.values = [0, Double.pi / 2, Double.pi, 3 * Double.pi / 2, 2 * Double.pi]
        rotationAnimation.duration = 1
        rotationAnimation.repeatCount = Float.infinity
        topImageView.layer.add(rotationAnimation, forKey: "rotationAnimation")
    }
 
    // 停止旋转动画的函数
    func stopRotationAnimation() {
        topImageView.removeFromSuperview()
    }
}
