//
//  YHCustomTextView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCustomTextView: UIView, UITextViewDelegate {

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    typealias Block = (String) -> Void
    var block: Block?
    
    lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .placeHolderColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.lineBreakMode = .byCharWrapping
        label.text = "请输入中文之外的语种"
        return label
    }()
    
    lazy var noTextTipsLable: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "无数据时候的提示"
        return label
    }()
    
    private lazy var bottomLine: UIView = {
        let view = UIView()
        view.backgroundColor = .clear// UIColor.separatorColor
        return view
    }()
    
    private lazy var additionHoldView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.contentBkgColor
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        return view
    }()
    
    var myTextView: UITextView!
    
    var needCheckFlag: Bool = false {
        didSet {
            layoutMyUI()
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        layoutMyUI()
    }
}

private extension YHCustomTextView {
    func setupUI() {
        backgroundColor = .clear
        
        addSubview(additionHoldView)
        additionHoldView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
        
        let textView: UITextView = UITextView()
        textView.backgroundColor = .clear
        textView.font = UIFont.PFSC_R(ofSize: 14)
        additionHoldView.addSubview(textView)
        textView.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        myTextView = textView
        myTextView.delegate = self
        myTextView.contentInset = UIEdgeInsets(top: 12, left: 12, bottom: 12, right: 12)
        
        additionHoldView.addSubview(tipsLabel)
        tipsLabel.snp.makeConstraints { make in
            make.top.equalTo(14)
            make.left.equalTo(16)
            make.right.equalTo(-12)
        }
        
        addSubview(noTextTipsLable)
        noTextTipsLable.snp.makeConstraints { make in
            make.top.equalTo(additionHoldView.snp.bottom).offset(6)
            make.left.right.equalToSuperview()
            make.height.equalTo(20)
        }
        
        noTextTipsLable.isHidden = true
        
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.top.equalTo(noTextTipsLable.snp.bottom).offset(12)
            make.bottom.equalToSuperview()
        }
    }
    
    private func layoutMyUI() {
        
        noTextTipsLable.snp.removeConstraints()
        bottomLine.snp.removeConstraints()
        
        if myTextView.text.isEmpty {
            tipsLabel.isHidden = false
        } else {
            tipsLabel.isHidden = true
        }
        
        if needCheckFlag == true, myTextView.text.isEmpty {
            noTextTipsLable.isHidden = false
            noTextTipsLable.snp.remakeConstraints { make in
                make.top.equalTo(additionHoldView.snp.bottom).offset(6)
                make.left.right.equalToSuperview()
                make.height.equalTo(20)
            }
            
            bottomLine.snp.remakeConstraints { make in
                make.left.right.equalToSuperview()
                make.height.equalTo(0.5)
                make.top.equalTo(noTextTipsLable.snp.bottom).offset(12)
                make.bottom.equalToSuperview()
            }
            
        } else {
            noTextTipsLable.isHidden = true
            bottomLine.snp.remakeConstraints { make in
                make.left.right.equalToSuperview()
                make.height.equalTo(0.5)
                make.top.equalTo(additionHoldView.snp.bottom).offset(12)
                make.bottom.equalToSuperview()
            }
        }
    }
}

extension YHCustomTextView: UITextFieldDelegate {
    internal func textViewDidChange(_ textView: UITextView) {
        if textView.text == "" {
            tipsLabel.isHidden = false
        } else {
            tipsLabel.isHidden = true
        }
        self.block?(textView.text)
    }
    
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        if !text.isEmpty {
            if textView.text.count > 999 {
                return false
            }
        }
        return true
    }
}

extension YHCustomTextView {
    func updateUI(title: String, value: String, type: YHOtherTextViewItemType = .unknowAwards) {
        myTextView.text = value
        if value.count > 0 {
            tipsLabel.isHidden = true
        } else {
            tipsLabel.isHidden = false
        }
        layoutMyUI()
    }
}
