//
//  YHVipLevelRightViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/2/21.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVipLevelRightViewController: YHBaseViewController, UITableViewDataSource, UITableViewDelegate {

    var level: YHMembershipLevel = .normal
    
    let titleListTag = 9527
    let valueListTag = 9528
    let valueHorizonalListTag = 9529
    
    var arr: [[YHVipLevelRightInfoModel]] = [
        
        [YHVipLevelRightInfoModel(type: .text, title: "专属顾问", text1: "4小时*5天专人", text2: "8小时*5天专人", text3: "12小时*7天专人", text4: "24小时*7天专人"),
        YHVipLevelRightInfoModel(type: .own, title: "专属积分消费", level1: 1, level2: 1, level3: 1, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "精品下午茶", level1: 1, level2: 1, level3: 1, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "线下沙龙", level1: 1, level2: 1, level3: 1, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "上门解答咨询", level1: 1, level2: 1, level3: 1, level4: 1)],
        
        [YHVipLevelRightInfoModel(type: .own, title: "高端早教盒子", level1: 0, level2: 1, level3: 1, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "会客体验中心", level1: 0, level2: 1, level3: 1, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "中港车接送服务", level1: 0, level2: 0, level3: 1, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "香港用车服务", level1: 0, level2: 0, level3: 0, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "国际驾照续期", level1: 0, level2: 0, level3: 0, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "香港择校规划", level1: 0, level2: 0, level3: 0, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: "品牌策划方案 ", level1: 0, level2: 0, level3: 0, level4: 1),
        YHVipLevelRightInfoModel(type: .own, title: " 高端私董会", level1: 0, level2: 0, level3: 0, level4: 1)]
        
    ]
    
    lazy var tableView1: UITableView = {
        let tableView = UITableView(frame: CGRect.zero, style: .grouped)
        tableView.tag = titleListTag
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = UIColor.white
        tableView.bounces = false
        tableView.separatorStyle = .none
        tableView.register(YHVipLevelRightTitleCell.self, forCellReuseIdentifier: YHVipLevelRightTitleCell.cellReuseIdentifier)
        tableView.delegate = self
        tableView.dataSource = self
        tableView.separatorStyle = .none
        return tableView
    }()
    
    lazy var tableView2: UITableView = {
        let tableView = UITableView(frame: CGRect.zero, style: .grouped)
        tableView.tag = valueListTag
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = UIColor.white
        tableView.bounces = false
        tableView.separatorStyle = .none
        tableView.register(YHVipLevelRightInfoCell.self, forCellReuseIdentifier: YHVipLevelRightInfoCell.cellReuseIdentifier)
        tableView.delegate = self
        tableView.dataSource = self
        tableView.separatorStyle = .none
        return tableView
    }()
    
    lazy var scrollView: UIScrollView = {
        let v = UIScrollView()
        v.backgroundColor = .yellow
//        v.isPagingEnabled = true
        v.tag = valueHorizonalListTag
        v.bounces = false
        v.contentInsetAdjustmentBehavior = .never
        v.showsHorizontalScrollIndicator = false
        v.delegate = self
        return v
    }()
    
    lazy var titleView: YHVipLevelRightHeaderView = {
        let v = YHVipLevelRightHeaderView(frame: .zero)
        v.level = self.level
        v.offSetXChange = {
            [weak self] offSetX in
            guard let self = self else { return }
            self.scrollView.contentOffset.x = offSetX
        }
        return v
    }()
    
    lazy var leftShadowImgV: UIImageView = {
        let v = UIImageView(image: UIImage(named: "mine_vip_list_shadow"))
        v.isHidden = true
        return v
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "我的等级权益".local
        view.backgroundColor = .white
        
        view.addSubview(titleView)
        view.addSubview(tableView1)
        view.addSubview(scrollView)
        view.addSubview(leftShadowImgV)

        scrollView.addSubview(tableView2)
        
        titleView.snp.makeConstraints { make in
            make.height.equalTo(48)
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.equalToSuperview()
        }
        
        tableView1.snp.makeConstraints { make in
            make.left.bottom.equalToSuperview()
            make.top.equalTo(titleView.snp.bottom)
            make.width.equalTo(KScreenWidth/3.0)
        }

        scrollView.snp.makeConstraints { make in
            make.top.equalTo(titleView.snp.bottom)
            make.left.equalTo(tableView1.snp.right)
            make.right.bottom.equalToSuperview()
        }
        tableView2.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
            make.width.equalTo(KScreenWidth/3.0*4.0)
            make.height.equalTo(scrollView)
        }
        
        leftShadowImgV.snp.makeConstraints { make in
            make.top.equalTo(titleView.snp.bottom)
            make.left.bottom.equalTo(scrollView)
            make.width.equalTo(12)
        }
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        autoScrollToOwnVipRight()
    }
    
    func autoScrollToOwnVipRight() {
        var offSetX = 0.0
        if self.level == .normal || self.level == .gold {
            offSetX = 0.0
        } else if self.level == .platinum || self.level == .diamond {
            offSetX = KScreenWidth * 2.0 / 3.0
        }
        printLog("&&&@ \(offSetX)")
        self.scrollView.contentOffset = CGPoint(x: offSetX, y: 0)
        self.titleView.scrollView.contentOffset = CGPoint(x: offSetX, y: 0)
    }
}

extension YHVipLevelRightViewController {
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if tableView.tag == titleListTag {
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHVipLevelRightTitleCell.cellReuseIdentifier, for: indexPath) as? YHVipLevelRightTitleCell else { return UITableViewCell() }
            if 0 <= indexPath.section, indexPath.section < arr.count {
                let a = arr[indexPath.section]
                if 0 <= indexPath.row, indexPath.row < a.count {
                    let model = a[indexPath.row]
                    cell.updateModel(model)
                }
                cell.backgroundColor = indexPath.row%2 == 1 ? .init(hex: 0xF8F9FB) : .white
            }
            return cell
        }
        guard let cell = tableView.dequeueReusableCell(withIdentifier: YHVipLevelRightInfoCell.cellReuseIdentifier, for: indexPath) as? YHVipLevelRightInfoCell else { return UITableViewCell() }

        if 0 <= indexPath.section, indexPath.section < arr.count {
            let a = arr[indexPath.section]
            if 0 <= indexPath.row, indexPath.row < a.count {
                let model = a[indexPath.row]
                cell.updateModel(model)
                cell.backgroundColor = indexPath.row%2 == 1 ? .init(hex: 0xF8F9FB) : .white
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44.0
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if 0 <= section, section < arr.count {
            let a = arr[section]
            return a.count
        }
        return 0
    }
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return arr.count
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        let model = section == 0 ? YHVipLevelRightInfoModel(type: .baseRightSection, title: "基础权益", text1: "5项", text2: "5项", text3: "5项", text4: "5项") : YHVipLevelRightInfoModel(type: .hightRightSection, title: "高端权益", text1: "0项", text2: "2项", text3: "3项", text4: "8项")
        let bgColor: UIColor = section == 0 ? .init(hex: 0xEBF0F9) : .init(hex: 0xFDF4E8)
        
        if tableView.tag == titleListTag {
            let cell = YHVipLevelRightTitleCell(style: .default, reuseIdentifier: YHVipLevelRightTitleCell.cellReuseIdentifier)
            
            cell.updateModel(model)
            cell.backgroundColor = bgColor
            return cell
        }
        let cell = YHVipLevelRightInfoCell(style: .default, reuseIdentifier: YHVipLevelRightInfoCell.cellReuseIdentifier)
        cell.updateModel(model)
        cell.backgroundColor = bgColor
        return cell
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
}

extension YHVipLevelRightViewController: UIScrollViewDelegate {
    
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        if scrollView.tag == titleListTag {
            tableView2.contentOffset.y = scrollView.contentOffset.y
            
        } else if scrollView.tag == valueListTag {
            tableView1.contentOffset.y = scrollView.contentOffset.y
            
        } else if scrollView.tag == valueHorizonalListTag {
            titleView.scrollView.contentOffset.x = scrollView.contentOffset.x
            leftShadowImgV.isHidden = scrollView.contentOffset.x <= 0.0
        }
    }
}
