//
//  YHMakePlanTopView.swift
//  galaxy
//
//  Created by EDY on 2025/3/31.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHMakePlanTopView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    var dataSource: YHMakePlanScoreModel? {
        didSet {
            let year = dataSource?.year ?? 0
            let rate = dataSource?.pass_rate ?? ""
            let a: ASAttributedString = .init("预计可续期(年) ", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor(hex: 0x6a7586)))
            let b: ASAttributedString = .init("\(year)", .font(UIFont.PFSC_M(ofSize: 16)), .foreground(UIColor.mainTextColor))
            yearsLabel.attributed.text = a + b
            let aa: ASAttributedString = .init("预测续签通过率 ", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor(hex: 0x6a7586)))
            let bb: ASAttributedString = .init("\(rate)", .font(UIFont.PFSC_M(ofSize: 16)), .foreground(UIColor.mainTextColor))
//            let c: ASAttributedString = .init("%", .font(UIFont.PFSC_M(ofSize: 16)), .foreground(UIColor.mainTextColor))
            percentageLabel.attributed.text = aa + bb
        }
    }
    
    private let yearsLabel: UILabel = {
        let label = UILabel()
        return label
    }()
    
    private let percentageLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .right
        return label
    }()
    
    lazy var custtomView: YHMakePlanCusttomHeadView = {
        let view = YHMakePlanCusttomHeadView()
        view.block = { tag in
            self.block?(tag)
        }
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    private func setUpView() {
        backgroundColor = .white
        let bgView = {
            let view = UIView()
            view.backgroundColor = UIColor(hex: 0xf8f9fb)
            view.layer.cornerRadius = 6
            return view
        }()
        addSubview(bgView)
        addSubview(yearsLabel)
        addSubview(percentageLabel)
        addSubview(custtomView)
       
        bgView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(42)
            make.top.equalTo(9)
        }
        yearsLabel.snp.makeConstraints { make in
            make.left.equalTo(34)
            make.height.equalTo(24)
            make.top.equalTo(18)
        }
        
        percentageLabel.snp.makeConstraints { make in
            make.right.equalTo(-34)
            make.height.equalTo(24)
            make.top.equalTo(18)
        }
        
        custtomView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
    }
}
