//
//  YHMemberCenterViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2025/2/20.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMemberCenterViewModel: YHBaseViewModel {
    var memberCenterInfo: YHMemberCenterInfo?
    
    func getMemberInfo(_ callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Member.memberBenefits
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHMemberCenterInfo.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBack(false, err)
                    return
                }
                self.memberCenterInfo = resultModel
                callBack(true, nil)
                
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBack(false, error)
            }
            
        } failBlock: { err in
            callBack(false, err)
        }
    }

}
