//
//  YHMatchCardUsageGuideView.swift
//  galaxy
//
//  Created by edy on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMatchCardUsageGuideView: UIView {

    // 底层蒙版
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    lazy var handImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "people_card_guide_hand"))
        return view
    }()
    
    lazy var leftGestureImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "people_card_guide_gesture_left"))
        return view
    }()
    
    lazy var rightGestureImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "people_card_guide_gesture_right"))
        return view
    }()
    
    lazy var knownBtn: UIButton = {
       let btn = UIButton()
        btn.setTitle("我知道了", for: .normal)
        btn.backgroundColor = .clear
        btn.setTitleColor(.white, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 14)
        btn.layer.cornerRadius = 3
        btn.layer.borderWidth = 1.0
        btn.layer.borderColor = UIColor.white.cgColor
        btn.addTarget(self, action: #selector(didKnownBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    @objc func didKnownBtnClicked() {
        self.removeFromSuperview()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    static func createView() -> YHMatchCardUsageGuideView {
        let view = YHMatchCardUsageGuideView(frame: UIScreen.main.bounds)
        return view
    }
    
    func createUI() {
        
        self.addSubview(self.blackMaskView)
        self.addSubview(self.handImgView)
        self.addSubview(self.leftGestureImgView)
        self.addSubview(self.rightGestureImgView)
        self.addSubview(self.knownBtn)
        
        self.blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        self.handImgView.snp.makeConstraints { make in
            make.width.equalTo(56)
            make.height.equalTo(87)
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
        }
        
        self.leftGestureImgView.snp.makeConstraints { make in
            make.width.equalTo(83)
            make.height.equalTo(42)
            make.right.equalTo(self.handImgView.snp.left).offset(-16)
            make.top.equalTo(self.handImgView.snp.top).offset(-16)
        }
        
        self.rightGestureImgView.snp.makeConstraints { make in
            make.width.equalTo(83)
            make.height.equalTo(42)
            make.left.equalTo(self.handImgView.snp.right).offset(16)
            make.top.equalTo(self.handImgView.snp.top).offset(-16)
        }
        self.knownBtn.snp.makeConstraints { make in
            make.width.equalTo(128)
            make.height.equalTo(45)
            make.centerX.equalToSuperview()
            make.top.equalTo(self.handImgView.snp.bottom).offset(40)
        }
    }
}
