//
//  YHHomeKingKongBlockView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeKingKongBlockView: UIView {
    
    var kingModel: [YHHomeFourKingInfoModel] = [] {
        didSet {
            if kingModel.count != 0 {
                arrData.removeAll()
                for item in kingModel {
                    let model = YHHomeKingKongBlockModel(type: "\(item.skip_type)", iconName: item.img_url, title: "")
                    arrData.append(model)
                }
                self.removeSubviews()
                self.initView()
            } else {
                self.removeSubviews()
                self.initView()
            }
        }
    }
    static let viewH: CGFloat = (KScreenWidth - 20.0 * 2 - 10.0 * 3) / 4.0
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var arrData: [YHHomeKingKongBlockModel] = [
        YHHomeKingKongBlockModel(type: "2", iconName: "kingkong_sfys", title: "身份优势"),
        YHHomeKingKongBlockModel(type: "3", iconName: "kingkong_yqyl", title: "邀请有礼"),
        YHHomeKingKongBlockModel(type: "4", iconName: "kingkong_khxs", title: "客户心声"),
        YHHomeKingKongBlockModel(type: "5", iconName: "kingkong_xgbs", title: "香港办事")
    ]
}

private extension YHHomeKingKongBlockView {
    func initView() {
        let itemGap: CGFloat = 10.0
        var offsetX: CGFloat = 0
        for (index, item) in arrData.enumerated() {
            let view = YHHomeKingKongBlockItem()
            view.dataModel = item
            addSubview(view)
            view.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.left.equalTo(offsetX)
                make.width.height.equalTo(YHHomeKingKongBlockView.viewH)
            }
            offsetX = offsetX + YHHomeKingKongBlockView.viewH + itemGap
            view.tag = item.type.intValue()
            let tap = UITapGestureRecognizer(target: self, action: #selector(tapView(gestureRecognizer:)))
            view.addGestureRecognizer(tap)
        }
    }
    
    @objc func tapView(gestureRecognizer: UITapGestureRecognizer) {
        if let tag = gestureRecognizer.view?.tag {
            switch tag {
            case 1:
                // 银河甄选
                YHAnalytics.track("APP_Home_KingKong_1")
                let vc = YHSelectViewController()
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 2:
                // 身份优势
                YHAnalytics.track("APP_Home_KingKong_2")
                let vc = YHStatusAdvantageVC()
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 3:
                // 邀请有礼
                YHAnalytics.track("APP_Home_KingKong_3")
                tapShareForGiftView()
            case 4:
                // 客户心声
                YHAnalytics.track("APP_Home_KingKong_4")
                let vc = YHOtherServiceViewController()
                vc.classID = 5
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 5:
                // 香港办事
                YHAnalytics.track("APP_Home_KingKong_5")
                let vc = YHHKEventCenterViewController()
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 6:
                // 银河商务
                if YHLoginManager.shared.isLogin() {
                } else {
                    YHOneKeyLoginManager.shared.oneKeyLogin()
                    return
                }
                YHAnalytics.track("Business_Delivery_Entry")
                var url = ""

#if DEBUG
                url = "https://test-hklife-business-uni.galaxy-immi.com/"
#elseif TESTENV
                url = "https://test-hklife-business-uni.galaxy-immi.com/"
#elseif UATENV
                url = "https://hklife-business-uni.galaxy-immi.com/"
#else
                url = "https://hklife-business-uni.galaxy-immi.com/"
#endif
                if YHLoginManager.shared.isLogin() {
                    let token = YHLoginManager.shared.h5Token
                    let urlHasParam = String.hasQueryParameters(urlString: url)
                    if urlHasParam {
                        url = url + "&param=" + token
                    } else {
                        url = url + "?param=" + token
                    }
                }
                
                // 2.增加导航栏高度
                var tUrl = url
                if !url.contains("navigationH=") {
                    tUrl = url + "?navigationH=\(k_Height_NavigationtBarAndStatuBar)"
                    if url.contains("?") {
                        tUrl = url + "&navigationH=\(k_Height_NavigationtBarAndStatuBar)"
                    }
                }
                
                let vc = YHH5WebViewVC()
                vc.url = tUrl
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 7:
                // 生意星
                gotoBusinessStar()
            default:
                break
            }
        }
    }
    
    func gotoBusinessStar() {
        if YHLoginManager.shared.isLogin() {
        } else {
            YHOneKeyLoginManager.shared.oneKeyLogin()
            return
        }
        YHAnalytics.track("APP_Home_Page_HKbusiness")
        var url = YHBaseUrlManager.shared.curBusinessStarUrl()

        if YHLoginManager.shared.isLogin() {
            let token = YHLoginManager.shared.h5Token
            
            let urlHasParam = String.hasQueryParameters(urlString: url)
            if urlHasParam {
                url = url + "&param=" + token
            } else {
                url = url + "?param=" + token
            }
        }
        
        // 2.增加导航栏高度
        var tUrl = url
        if !url.contains("navigationH=") {
            tUrl = url + "?navigationH=\(k_Height_NavigationtBarAndStatuBar)"
            if url.contains("?") {
                tUrl = url + "&navigationH=\(k_Height_NavigationtBarAndStatuBar)"
            }
        }
        
        let vc = YHH5WebViewVC()
        vc.url = tUrl
        self.parentViewController?.navigationController?.pushViewController(vc)
    }
    
    func tapShareForGiftView() {
        // 判断是否登录成功
        if YHLoginManager.shared.isLogin() {
            let vc = YHInvitationWithGiftsViewController()
            self.parentViewController?.navigationController?.pushViewController(vc)
        } else {
            YHOneKeyLoginManager.shared.oneKeyLogin()
            YHLoginManager.shared.loginSuccessActionBlock = {[weak self] in
                guard self != nil else { return }
                let vc = YHInvitationWithGiftsViewController()
                self?.parentViewController?.navigationController?.pushViewController(vc)
                YHLoginManager.shared.loginSuccessActionBlock = nil
            }
        }
    }
}
