//
//  YHFailPromptView.swift
//  galaxy
//
//  Created by EDY on 2024/4/1.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFailPromptView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var alertImageView: UIImageView = {
        let button = UIImageView()
        button.image = UIImage(named: "fail_prompt_image")
        return button
    }()
    
    lazy var titleLable: UILabel = {
        let lable0 = UILabel(text: "")
        lable0.textColor = UIColor.failColor
        lable0.font = UIFont.PFSC_R(ofSize: 12)
        lable0.numberOfLines = 0
        return lable0
    }()
    
    func setPrompt(_ prompt: String) {
        titleLable.text = "驳回原因：" + prompt
    }
}

private extension YHFailPromptView {
    func initView() {
        backgroundColor = UIColor(hex: 0xfeeded)
        addSubview(alertImageView)
        alertImageView.snp.makeConstraints { make in
            make.top.equalTo(10)
            make.left.equalTo(18)
            make.width.height.equalTo(16)
        }
        
        addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-18)
            make.top.equalTo(9)
        }
    }
    
}
