//
//  YHIndustryLocationCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIndustryLocationCell: UITableViewCell {

    static let cellReuseIdentifier = "YHIndustryLocationCell"
    
    var industry: String = "" {
        didSet {
            tips2Label.text = industry
        }
    }
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.clipsToBounds = true
        return view
    }()
    
    lazy var dotLine: YHDashLineView = {
        let view = YHDashLineView(strokeColor: UIColor.init(hex: 0xF7F2ED).cgColor, lineWidth: 0.8, lineDashPattern: [3, 3])
        return view
    }()
    
    lazy var markImgV: UIImageView = {
        let v = UIImageView(image: UIImage(named: "my_scheme_mark"))
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 17)
        label.textColor = .mainTextColor
        label.text = "行业定位"
        return label
    }()
    
    lazy var tips1Label: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor
        label.numberOfLines = 0
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 4
        let attributes = [NSAttributedString.Key.paragraphStyle: paragraphStyle]
        label.attributedText = NSAttributedString(string: "根据您目前给来的材料，初步建议您申请的行业：", attributes: attributes)
        return label
    }()
    
    lazy var tips2Label: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 16)
        label.textColor = .init(hex: 0xD48638)
        label.numberOfLines = 0
        label.text = "其他（环境科学、HSE）"
        return label
    }()
    
    lazy var tips3Label: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .init(hex: 0x8993A2)
        label.numberOfLines = 0        
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 4
        let attributes = [NSAttributedString.Key.paragraphStyle: paragraphStyle]
        label.attributedText = NSAttributedString(string: "后续会根据您文书准备的补充情况来最终确定，如有修改会再告知您。", attributes: attributes)
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.clipsToBounds = true
        
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(dotLine)
        whiteContentView.addSubview(markImgV)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(tips1Label)
        whiteContentView.addSubview(tips2Label)
        whiteContentView.addSubview(tips3Label)
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.bottom.equalToSuperview()
        }
        
        dotLine.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(0)
            make.height.equalTo(1)
        }
        
        markImgV.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.width.equalTo(4)
            make.height.equalTo(16)
            make.centerY.equalTo(titleLabel)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(26)
            make.height.equalTo(24)
            make.left.equalTo(markImgV.snp.right).offset(8)
            make.right.equalTo(-24)
        }
        
        tips1Label.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(titleLabel.snp.bottom).offset(16)
        }
        
        tips2Label.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(tips1Label.snp.bottom).offset(6)
        }
        
        tips3Label.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(tips2Label.snp.bottom).offset(6)
            make.bottom.equalTo(-26)
        }
    }

}
