//
//  YHResignScheduleLineCollectCell.swift
//  galaxy
//
//  Created by edy on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignScheduleLineCollectCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHResignScheduleLineCollectCell"

    lazy var numLabel: UILabel =  {
        var label = UILabel()
        label.font = UIFont(name: "DINAlternate-Bold", size: 11)!
        label.textAlignment = .center
        label.textColor = UIColor.mainTextColor(alpha: 0.7)
        label.backgroundColor = .white
        label.layer.cornerRadius = 17.0/2.0
        label.clipsToBounds = true
        return label
    }()
    
    lazy var titleLabel: UILabel =  {
        var label = UILabel()
        label.font = .PFSC_R(ofSize: 11)
        label.textAlignment = .left
        label.textColor = UIColor.mainTextColor
        return label
    }()
    
    lazy var timeLabel: UILabel =  {
        var label = UILabel()
        label.font = .PFSC_R(ofSize: 11)
        label.textAlignment = .left
        label.textColor = UIColor.mainTextColor(alpha: 0.3)
        return label
    }()
    
    lazy var leftDotView: YHDashLineView = {
        let view = YHDashLineView(strokeColor: UIColor.init(hex: 0x121A26, alpha: 0.12).cgColor, lineWidth: 0.8, lineDashPattern: [3, 3])
        return view
    }()
    
    lazy var rightDotView: YHDashLineView = {
        let view = YHDashLineView(strokeColor: UIColor.init(hex: 0x121A26, alpha: 0.12).cgColor, lineWidth: 0.8, lineDashPattern: [3, 3])
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    func setupUI() {
        
        contentView.addSubview(numLabel)
        contentView.addSubview(titleLabel)
        contentView.addSubview(timeLabel)
        contentView.addSubview(leftDotView)
        contentView.addSubview(rightDotView)

        numLabel.snp.makeConstraints { make in
            make.width.height.equalTo(17)
            make.top.equalTo(16)
            make.centerX.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(numLabel.snp.bottom).offset(6)
            make.centerX.equalToSuperview()
            make.height.equalTo(15)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(1)
            make.height.equalTo(15)
            make.centerX.equalToSuperview()
        }
        
        leftDotView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(numLabel.snp.left).offset(-8)
            make.centerY.equalTo(numLabel)
            make.height.equalTo(0.8)
        }
        
        rightDotView.snp.makeConstraints { make in
            make.right.equalTo(0)
            make.left.equalTo(numLabel.snp.right).offset(8)
            make.centerY.equalTo(numLabel)
            make.height.equalTo(0.8)
        }
    }
    
    func updateModel(_ model: YHScheduleLineStepModel) {
        
        numLabel.text = "\(model.index)"
        titleLabel.text = model.title
        timeLabel.text = model.time
        
        numLabel.textColor = model.isNeedUserAction ? UIColor.mainTextColor(alpha: 0.7) : UIColor.mainTextColor(alpha: 0.18)
        titleLabel.textColor = model.isNeedUserAction ? UIColor.mainTextColor(alpha: 0.7) : UIColor.mainTextColor(alpha: 0.3)
        timeLabel.textColor = model.isNeedUserAction ? UIColor.mainTextColor(alpha: 0.3) : UIColor.mainTextColor(alpha: 0.18)

    }
}
