//
//  YHGCCollegeSearchViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/1/6.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCCollegeSearchViewController: YHBaseViewController {
    
    var orderId: Int = 0
    var searchCollegeName: String?
    var selectBlock: ((String?, Int) -> Void)?
    var colleges: [YHCollegeInfo] = []
    var isShowSureButton: Bool = true
    let educationRequest: YHEducationRequestViewModel = YHEducationRequestViewModel()

    lazy var searchBar: YHCollegeSearchBar = {
        let bar = YHCollegeSearchBar.createBar()
        return bar
    }()
    
    lazy var tableView: UITableView = {
        
        let tableView = UITableView(frame: .zero, style: .plain)
        
        if #available(iOS 11.0, *) {
            tableView.contentInsetAdjustmentBehavior = .never
        }
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = .white
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHCollegeNameCell.self, forCellReuseIdentifier: YHCollegeNameCell.cellReuseIdentifier)
        tableView.backgroundView = emptyDataTipsView
        return tableView
    }()
    
    lazy var emptyDataTipsView: YHEmptyDataView = {
        let view = YHEmptyDataView.createView("无搜索结果", kEmptySearchBgName)
        view.topMargin = 130
        view.isHidden = true
        return view
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        createUI()
        if searchCollegeName != nil {
            searchCollege()
        }
    }
    
    func createUI() {
        
        self.view.backgroundColor = .white
        self.gk_navTitle = "学校名称".local

        view.addSubview(tableView)
        view.addSubview(searchBar)
        searchBar.confirmBtn.isHidden = !isShowSureButton
        if let searchCollegeName = searchCollegeName {
            searchBar.textField.text = searchCollegeName
        }
        searchBar.textChange = {
           [weak self]  text in
            guard let self = self else { return }
            searchCollegeName = text
            self.searchCollege()
        }
        searchBar.confirmBlock = {
            [weak self] in
            guard let self = self else { return }
            if let selectBlock = selectBlock {
                selectBlock(searchBar.textField.text, 0)
                self.navigationController?.popViewController(animated: true)
            }
        }
        
        searchBar.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(YHCollegeSearchBar.height)
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar+16)
        }
        
        tableView.snp.makeConstraints { make in
            make.top.equalTo(searchBar.snp.bottom).offset(8)
            make.left.right.bottom.equalToSuperview()
        }
    }
    
    func searchCollege() {
        
        let param: [String: Any] = ["order_id": orderId,
                                  "name": searchCollegeName ?? "",
                                  "page": 1,
                                  "page_size": 100
                                 ]
        self.educationRequest.searchCollegeInfoList(params: param) {
            [weak self] success, _ in
            guard let self = self else { return }
            if success {
                if let list = self.educationRequest.collegeList {
                    colleges = list
                } else {
                    colleges = []
                }
                emptyDataTipsView.isHidden = colleges.count > 0
            }
            self.tableView.reloadData()
        }
    }
}

extension YHGCCollegeSearchViewController: UITableViewDelegate, UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return colleges.count
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        guard let cell = tableView.dequeueReusableCell(withIdentifier: YHCollegeNameCell.cellReuseIdentifier, for: indexPath) as? YHCollegeNameCell else { return UITableViewCell() }
        if indexPath.row < colleges.count {
            let college: YHCollegeInfo = colleges[indexPath.row]
            
            var name = ""
            if !isEmptyString(college.zhName) {
                name += college.zhName
            }
            if !isEmptyString(college.zhName) && !isEmptyString(college.enName) {
                name += "/"
            }
            if !isEmptyString(college.enName) {
                name += college.enName
            }
            cell.titleLabel.text = name
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if let selectBlock = selectBlock {
            if indexPath.row < colleges.count {
                let college: YHCollegeInfo = colleges[indexPath.row]
                selectBlock(college.getFullCollegeName(), college.id)
                self.navigationController?.popViewController(animated: true)
            }
            
        }
    }
}
