//
//  YHGCEducationDetailVC.swift
//  galaxy
//
//  Created by Dufet on 2024/12/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SwifterSwift
// import Toast_Swift

class YHGCEducationDetailVC: YHBaseViewController {
    
    // 【WARNING!】新添加 传orderId 已有信息传detailId和orderId
    // 订单ID
    var orderId: Int = 0
    // 学历ID
    var detailId: Int = 0
    // 是否显示未填写错误提示
    var isNeedShowError = false
    let educationRequest: YHEducationRequestViewModel = YHEducationRequestViewModel()
    var detailInfo: YHEducationDetailInfo = YHEducationDetailInfo()
    
    var items: [[YHFormItemProtocol]] = []
    
    lazy var tableView: UITableView = {
        
        let tableView = UITableView(frame: .zero, style: .grouped)
        
        if #available(iOS 11.0, *) {
            tableView.contentInsetAdjustmentBehavior = .never
        }
        tableView.estimatedSectionHeaderHeight = 14.0
        tableView.estimatedSectionFooterHeight = 1.0
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = UIColor(hexString: "#F8F8F8")
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHFormItemTitleCell.self, forCellReuseIdentifier: YHFormItemTitleCell.cellReuseIdentifier)
        tableView.register(YHFormItemAddCell.self, forCellReuseIdentifier: YHFormItemAddCell.cellReuseIdentifier)
        tableView.register(YHFormItemInputTextCell.self, forCellReuseIdentifier: YHFormItemInputTextCell.cellReuseIdentifier)
        tableView.register(YHFormItemSelectSheetCell.self, forCellReuseIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier)
        tableView.register(YHGCEducationCerUploadCell.self, forCellReuseIdentifier: YHGCEducationCerUploadCell.cellReuseIdentifier)
        return tableView
    }()
    
    var bottomView: YHSaveAndSubmitView = {
        let view = YHSaveAndSubmitView.createView()
        view.isHiddenSave = true
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.gk_navTitle = "学历".local
        self.gk_navigationBar.backgroundColor = .white
        view.backgroundColor = UIColor(hexString: "#F8F8F8")
        createUI()
    }
    
    func createUI() {
        
        view.addSubview(tableView)
        view.addSubview(bottomView)
        
        bottomView.saveBlock = {
            [weak self] in
            guard let self = self else { return }
            saveDetailInfo(isSubmit: false, isNeedPop: true, isShowToast: true)
        }
        
        bottomView.submitBlock = {
            [weak self] in
            guard let self = self else { return }
            submitInfo()
        }
        
        bottomView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
            make.height.equalTo(YHSaveAndSubmitView.height)
        }
        
        tableView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(bottomView.snp.top)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
        }
        
        loadInfo()
        if self.detailId != 0 { // 有学历ID则该学历已存在
            getDetailInfo()
        }
    }
    
    func loadInfo() {
                
        items.removeAll()
        
        let title0 = YHFormTitleItem(type: .mainApplicantEducation)
        let item00 = YHFormDetailItem(type: .universityFullName)
        if detailInfo.degree.contains("学士学位") {
            item00.tips = "请输入学校全称".local
            item00.placeHolder = "请输入学校全称，例：清华，需填全称“清华大学”".local
            
        } else {
            item00.tips = "请选择学校".local
            item00.placeHolder = "请选择学校"
        }
        item00.value = detailInfo.college
        
        let item03 = YHFormDetailItem(type: .graduateTime)
        item03.tips = "请选择年月".local
        item03.placeHolder = "请选择年月".local
        item03.value = detailInfo.graduateTime
        
        let item04 = YHFormDetailItem(type: .educationMajor)
        item04.tips = "请选择专业".local
        item04.placeHolder = "请选择专业".local
        item04.value = detailInfo.major
        
        let item09 = YHFormDetailItem(type: .detailMajor)
        item09.tips = "请输入专业".local
        item09.placeHolder = "请输入专业".local
        item09.value = detailInfo.majorOther
        
        let item01 = YHFormDetailItem(type: .educationStyle)
        item01.tips = "请选择授课形式".local
        item01.placeHolder = "请选择授课形式"
        item01.value = detailInfo.teachingFormat
        
        let item05 = YHFormDetailItem(type: .educationDegree)
        item05.tips = "请选择学位".local
        item05.placeHolder = "请选择学位".local
        item05.value = detailInfo.getDegree()
        
//        let item02 = YHFormDetailItem(type: .educationTime)
//        item02.tips = "请选择年月".local
//        item02.placeHolder = "请选择年月".local
//        item02.value = detailInfo.admissionTime
        
//        let item06 = YHFormDetailItem(type: .degreeType)
//        item06.tips = "请选择学位类型".local
//        item06.value = detailInfo.degreeType

        let item07 = YHFormDetailItem(type: .educationCountry)
        item07.tips = "请选择国家及地区".local
        item07.placeHolder = "请选择国家及地区".local
        item07.value = detailInfo.schoolAddress.country
        
        let item08 = YHFormDetailItem(type: .educationCity)

        if detailInfo.isSchoolInAboard() {
            item08.value = detailInfo.schoolAddress.foreign
            item08.tips = "请输入城市".local

        } else {
            item08.value = detailInfo.schoolAddress.area.joined(separator: ",")
            item08.tips = "请选择城市".local
        }
        
        var arr0: [YHFormItemProtocol] = [title0, item00, item03, item04, item05, item07, item08]
        if detailInfo.isNeedInputMajor() {
            arr0 = [title0, item00, item03, item04, item09, item05, item07, item08]
        }
        items.append(arr0)
        
//        let item10 = YHFormDetailItem(type: .cerUpload)
//        let arr1:[YHFormItemProtocol] = [item10]
//        items.append(arr1)

        self.tableView.reloadData()
    }
}

extension YHGCEducationDetailVC: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section >= items.count { return 0 }
        let arr = items[section]
        return arr.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if indexPath.section >= items.count { return createDefaultCell(indexPath) }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return createDefaultCell(indexPath) }
        let item: YHFormItemProtocol = arr[indexPath.row]

        if item is YHFormTitleItem { // 是标题
            
            guard let formItem = item as? YHFormTitleItem else { return UITableViewCell() }
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemTitleCell.cellReuseIdentifier, for: indexPath) as? YHFormItemTitleCell else { return UITableViewCell() }
            cell.setTitleAndSubTitle(title: formItem.getTitle())
            return cell
        }
        
        if item is YHFormDetailItem {
            
            guard let detailItem = item as? YHFormDetailItem else { return UITableViewCell() }
            let cellType = getCellType(detailItem)
            if cellType == .inputText {
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemInputTextCell.cellReuseIdentifier, for: indexPath) as? YHFormItemInputTextCell else { return UITableViewCell() }
                var isValueValid = false
                if let value = detailItem.value, !value.isEmpty {
                    isValueValid = true
                }
                cell.setTips(detailItem.tips, isShow: (isNeedShowError && !isValueValid))
                cell.placeHolder = detailItem.placeHolder
                cell.isMust = detailItem.isNeed
                cell.title = detailItem.getTitle()
                cell.text = detailItem.value
                
                cell.textInputCondtion = {
                    textField in
                    
                    var max = -1
                    if detailItem.type == .detailMajor {
                        max = 50
                    } else if detailItem.type == .educationCity {
                        max = 100
                    }

                    if max > 0 {
                        if let textStr = textField.text {
                            textField.text = (textStr.count > max ? textStr[safe: ..<max] : textStr)
                        }
                    }
                    return true
                }
                
                cell.textChange = {
                    [weak self] (text, isEditEnd) in
                    guard let self = self else { return }
                    // 只有国外城市才需输入，国内城市使用的是选择器
                    if detailItem.type == .educationCity {
                        if let text = text, !text.isEmpty {
                            detailInfo.schoolAddress.foreign = text
                        } else {
                            detailInfo.schoolAddress.foreign = ""
                        }
                        
                    } else if detailItem.type == .detailMajor {
                        if let text = text, !text.isEmpty {
                            detailInfo.majorOther = text
                        } else {
                            detailInfo.majorOther = ""
                        }
                    } else if detailItem.type == .universityFullName {
                        if let text = text, !text.isEmpty {
                            detailInfo.college = text
                        } else {
                            detailInfo.college = ""
                        }
                    }
                    if isEditEnd {
                        loadInfo()
                        saveInfoSilent()
                    }
                }
                return cell
                
            } else if cellType == .selectSheet {
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier, for: indexPath) as? YHFormItemSelectSheetCell else { return UITableViewCell() }
                cell.isShowTipsButton = (detailItem.type == .degreeType)
                cell.tipsBtnClickBlock = {
                    YHWholeScreenTipsView.show(type: .degreeType, targetView: cell.tipsButton)
                }
                cell.placeHolder = detailItem.placeHolder
                cell.isMust = detailItem.isNeed
                cell.title = detailItem.getTitle()
                cell.detail = detailItem.value
                var isValueValid = false
                if let value = detailItem.value, !value.isEmpty {
                    isValueValid = true
                }
                cell.setTips(detailItem.tips, isShow: (isNeedShowError && !isValueValid))
                return cell
                
            } else if cellType == .cerUpload {
                
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHGCEducationCerUploadCell.cellReuseIdentifier, for: indexPath) as? YHGCEducationCerUploadCell else { return UITableViewCell() }
                return cell
            }
        }
        
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
    
    func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        
        if indexPath.section >= items.count { return  }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return }
        
        createCorner(cell: cell, arr: arr, indexPath: indexPath)
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        return UIView()
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 14.0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        let arr = items[indexPath.section]
        let item: YHFormItemProtocol = arr[indexPath.row]
        
        // 标题
        if item is YHFormTitleItem {
            return
        }
        if item is YHFormDetailItem {
            guard let detailItem = item as? YHFormDetailItem else { return }
            
            if detailItem.type == .universityFullName { // 选择大学名称
              if detailInfo.degree.contains("学士学位") {
                    // 此时学位是输入
                    return
               }

               let vc = YHGCCollegeSearchViewController()
               vc.isShowSureButton = false
               vc.orderId = self.orderId
               vc.searchCollegeName = detailInfo.college
               vc.selectBlock = {
                    [weak self] text, id in
                    guard let self = self else { return }
                    if let text = text, !text.isEmpty {
                        detailInfo.college = text
                    } else {
                        detailInfo.college = ""
                    }
                    detailInfo.college_id = id
                    loadInfo()
                    saveInfoSilent()
                }
               self.navigationController?.pushViewController(vc)
                
            } else if detailItem.type == .educationStyle { // 授课形式
                
                YHSheetPickerView.show(type: .educationStyle, selectTitle: detailInfo.teachingFormat) {
                    [weak self]  item in
                    guard let self = self else { return }
                    detailInfo.teachingFormat = item.title
                    loadInfo()
                    saveInfoSilent()
                }
                
            } else if detailItem.type == .educationTime || detailItem.type == .graduateTime { // 入学及毕业年月
                
                var title = ""
                var dateStr = ""
                if detailItem.type == .educationTime {
                    title = "选择入学日期"
                    dateStr = detailInfo.admissionTime
                } else if detailItem.type == .graduateTime {
                    title = "选择毕业日期"
                    dateStr = detailInfo.graduateTime
                }
                YHDatePickView.show(type: .yyyymm, title: title, lastIsTaday: true, currentDay: dateStr) {
                    [weak self] dateStr in
                    guard let self = self else { return }
                    
                    let format = DateFormatter()
                    format.dateFormat = "yyyy-MM"
                    if let selectDate = format.date(from: dateStr) {
                        let selectTimeInterval = selectDate.timeIntervalSince1970
                        let currentTimeInterval = Date().timeIntervalSince1970
                        if detailItem.type == .educationTime { // 选择入学日期
                            // 入学日期须早于当前日期
                            if selectTimeInterval > currentTimeInterval {
                                YHHUD.flash(message: "入学日期不能晚于当前日期")
                                return
                            }
                            if !detailInfo.graduateTime.isEmpty, let endDate = format.date(from: detailInfo.graduateTime) {
                                let endTimeInterval = endDate.timeIntervalSince1970
                                
                                if selectTimeInterval > endTimeInterval {
                                    YHHUD.flash(message: "入学日期不能晚于毕业日期")
                                    return
                                }
                            }
                            detailInfo.admissionTime = dateStr
                        }
                        
                        if detailItem.type == .graduateTime { // 选择毕业日期
        
                            if !detailInfo.admissionTime.isEmpty, let startDate = format.date(from: detailInfo.admissionTime) {
                                let startTimeInterval = startDate.timeIntervalSince1970

                                if selectTimeInterval < startTimeInterval {
                                    YHHUD.flash(message: "毕业日期不能早于入学日期")
                                    return
                                }
                            }
                            detailInfo.graduateTime = dateStr
                        }
                    }
    
                    loadInfo()
                    saveInfoSilent()
                }
                
            } else if detailItem.type == .educationDegree { // 学位
                
                YHSheetPickerView.show(type: .degree2, selectTitle: detailInfo.degree) {
                    [weak self]  item in
                    guard let self = self else { return }
                    detailInfo.hasBachelorDegree = item.index
                    loadInfo()
                    saveInfoSilent()
                }
                
            } else if detailItem.type == .degreeType { // 学位类型
                
                YHSheetPickerView.show(type: .degreeCategory, selectTitle: "工程学") {
                   [weak self]  selectItem in
                    guard let self = self else { return }
                    detailInfo.degreeType = selectItem.title
                    loadInfo()
                    saveInfoSilent()
                }
                
            } else if detailItem.type == .educationCountry { // 上课国家/地区
                
                let vc = YHSelectCountryViewController()
                vc.backLocationStringController = {
                    [weak self] country in
                    guard let self = self else { return }
                    detailInfo.schoolAddress.country = country
                    detailInfo.isAboardSchool = detailInfo.isSchoolInAboard()
                    loadInfo()
                    saveInfoSilent()
                }
                 self.navigationController?.pushViewController(vc)
                
            } else if detailItem.type == .educationCity { // 上课城市
                
                if detailInfo.isSchoolInAboard() { return }
                
                let vc = YHAddressViewController()
                vc.backLocationStringController = {
                     [weak self] (_, string2, string3, _) in
                     guard let self = self else { return }
                    var citys: [String] = []
                    if !isEmptyString(string2) {
                        citys.append(string2)
                    }
                    if !isEmptyString(string3) {
                        citys.append(string3)
                    }
                     detailInfo.schoolAddress.area = citys
                     loadInfo()
                     saveInfoSilent()
                }
                self.present(vc, animated: true)
                
            } else if detailItem.type == .educationMajor { // 专业
                
                YHSheetPickerView.show(type: .major, selectTitle: detailInfo.major) {
                    [weak self]  item in
                    guard let self = self else { return }
                    detailInfo.major = item.title
                    loadInfo()
                    saveInfoSilent()
                }
                                
//                let vc = YHMajorSearchViewController()
//                vc.orderId = self.orderId
//                vc.searchMajorName = detailInfo.major
//                vc.selectBlock = {
//                     [weak self] text in
//                     guard let self = self else { return }
//                     if let text = text, !text.isEmpty  {
//                         detailInfo.major = text
//                     } else {
//                         detailInfo.major = ""
//                     }
//                     loadInfo()
//                     saveInfoSilent()
//                 }
//                self.navigationController?.pushViewController(vc)
            }
        }
    }
    
    func createDefaultCell(_ indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
        
    func createCorner(cell: UITableViewCell, arr: [Any], indexPath: IndexPath) {
        // 设置每块section圆角
        
        if indexPath.row == 0, indexPath.row == arr.count-1 {
            let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue |
                                                UIRectCorner.topRight.rawValue |
                                                UIRectCorner.bottomLeft.rawValue |
                                                UIRectCorner.bottomRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            return
        }
        if indexPath.row == 0 {
            let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            return
        }
        
        if indexPath.row == arr.count-1 {
            let corner = UIRectCorner(rawValue: UIRectCorner.bottomLeft.rawValue | UIRectCorner.bottomRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            return
        }
        
        cell.layer.mask = nil
    }
    
    func getCellType(_ item: Any) -> HKFormItemCellType {
        if item is YHFormTitleItem {
            return .title
        }
        
        if item is YHFormDetailItem {
            guard let detailItem = item as? YHFormDetailItem else { return .defaultType }
            
            if detailItem.type == .cerUpload {
                return .cerUpload
            }
            
//            学位选择：学士学位，
//            学习全称：直接输入学校名称，不需要进入搜索页面
//
//            学位选择：硕士学位/博士学位，
//            学习全称：需要进入名校库搜索页面，模糊搜索名校，若搜不到直接输入
            
            if detailItem.type == .universityFullName { // 学校全称
                if detailInfo.degree.contains("学士学位") {
                    return .inputText
                }
                return .selectSheet
            }
            
            if detailItem.type == .educationCity {
                if detailInfo.isSchoolInAboard() {
                    return .inputText
                }
                return .selectSheet
            }
            
            if detailItem.type == .detailMajor {
                return .inputText
            }
            
            if  detailItem.type == .educationMajor
                || detailItem.type == .educationStyle
                || detailItem.type == .educationTime
                || detailItem.type == .graduateTime
                || detailItem.type == .educationDegree
                || detailItem.type == .degreeType
                || detailItem.type == .educationCountry {
                
                return .selectSheet
            }
        }
        return .defaultType
    }
}

extension YHGCEducationDetailVC {
    func getDetailInfo() {
        self.educationRequest.getEducationDetailInfo(params: ["id": self.detailId,
                                                              "order_id": self.orderId]) {
            [weak self] success, _ in
            guard let self = self else { return }
            if success {
                if let educationDetailInfo = self.educationRequest.educationDetailInfo {
                    detailInfo = educationDetailInfo
                }
                loadInfo()
            }
        }
    }
    
    func submitInfo() {
        let isChecked = checkIntegrity()
        isNeedShowError = !isChecked
        
        self.tableView .reloadData()
        
        if !isChecked {
            YHHUD.flash(message: "资料还未填完")
            return
        }
        saveDetailInfo(isSubmit: true, isNeedPop: true, isShowToast: true)
    }
    
    // 检查填写信息完整性
    func checkIntegrity() -> Bool {
        
        if detailInfo.college.isEmpty
            || detailInfo.graduateTime.isEmpty
            || detailInfo.schoolAddress.country.isEmpty {
            return false
        }
        
//        if detailInfo.certConfirm == 0 { // 证件提供确认
//            return false
//        }
        
        if detailInfo.getDegree().isEmpty {
            return false
        }
        
        if detailInfo.isNeedInputMajor(), detailInfo.majorOther.isEmpty {
            return false
        }
        
        if detailInfo.isSchoolInAboard(), detailInfo.schoolAddress.foreign.isEmpty {
            return false
        }
        
        if !detailInfo.isSchoolInAboard(), detailInfo.schoolAddress.area.count <= 0 {
            return false
        }
        return true
    }
    
    func saveInfoSilent() {
        if detailId != 0 {
            saveDetailInfo(isSubmit: false, isNeedPop: false, isShowToast: false)
        }
    }
    
    // 保存信息 isNeedPop：保存成功后是否退出该页面
    func saveDetailInfo(isSubmit: Bool, isNeedPop: Bool, isShowToast: Bool) {
        
        guard var dict: [String: Any] = detailInfo.toDictionary() else { return }
        dict["order_id"] = self.orderId
        dict["is_aboard_school"] = detailInfo.isSchoolInAboard()
        dict["college_id"] = detailInfo.college_id

        self.educationRequest.saveEducationInfo(params: dict, isSilent: !isShowToast) {
            [weak self] success, error in
            guard let self = self else { return }
            
            if success {
                if isShowToast {
                    YHHUD.flash(message: isSubmit ? "提交成功":"保存成功" )
                }
                if isNeedPop {
                    self.navigationController?.popViewController(animated: true)
                }
                
            } else {
                if isShowToast {
                    var errorMsg = isSubmit ? "提交失败" : "保存失败"
                    if let errMsg = error?.errorMsg, errMsg.count > 0 {
                        errorMsg = errMsg
                    }
                    YHHUD.flash(message: errorMsg)
                }
            }
        }
    }
}
