//
//  YHCollectionViewLeftAlignedFlowLayout.swift
//  galaxy
//
//  Created by AlexZhu on 9/22/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCollectionViewLeftAlignedFlowLayout: UICollectionViewFlowLayout {
    override func layoutAttributesForElements(in rect: CGRect) -> [UICollectionViewLayoutAttributes]? {
        guard let attrsArry = super.layoutAttributesForElements(in: rect) else {
            return nil
        }
        for i in 0 ..< attrsArry.count {
            if i != attrsArry.count - 1 {
                let curAttr = attrsArry[i] // 当前attr
                let nextAttr = attrsArry[i + 1] // 下一个attr
                /// 如果下一个在同一行则调整，不在同一行则跳过
                if curAttr.frame.minY == nextAttr.frame.minY {
                    if nextAttr.representedElementCategory != .cell {
                        break
                    }
                    if nextAttr.frame.minX - curAttr.frame.maxX > minimumInteritemSpacing {
                        var frame = nextAttr.frame
                        let x = curAttr.frame.maxX + minimumInteritemSpacing
                        frame = CGRect(x: x, y: frame.minY, width: frame.width, height: frame.height)
                        nextAttr.frame = frame
                    }
                } else {
                    if curAttr.representedElementCategory != .cell {
                        break
                    }
                    var edgeInset: UIEdgeInsets = sectionInset
                    if let collectionView = collectionView, let flowDelegate = collectionView.delegate as? UICollectionViewDelegateFlowLayout, let tempEdgeInset = flowDelegate.collectionView?(collectionView, layout: self, insetForSectionAt: curAttr.indexPath.section) {
                        edgeInset = tempEdgeInset
                    }
                    /// 独立成行的也左对齐
                    let isFirstSingleCell = i == 0 && curAttr.frame.minY < nextAttr.frame.minY
                    let isNextSingleCell = i > 0 && attrsArry[i - 1].frame.minY < curAttr.frame.minY && curAttr.frame.minY < nextAttr.frame.minY
                    if isFirstSingleCell || isNextSingleCell {
                        var frame = curAttr.frame
                        frame = CGRect(x: edgeInset.left, y: frame.minY, width: frame.width, height: frame.height)
                        curAttr.frame = frame
                    }
                    
                }
            } else {
                let curAttr = attrsArry[i]
                if curAttr.representedElementCategory != .cell {
                    break
                }
                var edgeInset: UIEdgeInsets = sectionInset
                if let collectionView = collectionView, let flowDelegate = collectionView.delegate as? UICollectionViewDelegateFlowLayout, let tempEdgeInset = flowDelegate.collectionView?(collectionView, layout: self, insetForSectionAt: curAttr.indexPath.section) {
                    edgeInset = tempEdgeInset
                }
                /// 只有一个也左对齐
                let onlyOneCell = i == 0
                /// 最后一行也左对齐
                let lastSingleCell = i > 0 && attrsArry[i - 1].frame.minY < curAttr.frame.minY
                if onlyOneCell || lastSingleCell {
                    var frame = curAttr.frame
                    frame = CGRect(x: edgeInset.left, y: frame.minY, width: frame.width, height: frame.height)
                    curAttr.frame = frame
                }
            }
        }
        return attrsArry
    }
}
