//
//  YHLookResignResultFootView.swift
//  galaxy
//
//  Created by EDY on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHLookResignResultFootView: UIView {
    var titleLabel: UILabel!
    var messageLabel: UILabel!

    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let view = UILabel()
            view.text = "温馨提示："
            view.textColor = UIColor.mainTextColor50
            view.font = UIFont.PFSC_R(ofSize: 14)
            view.numberOfLines = 0
            return view
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.top.left.equalTo(20)
        }
        
        messageLabel = {
            let view = UILabel()
            view.text = "1、收到《入境处递交回执》后，建议在港等待获批结果，若有需要离港，请在签证到期前离港。\n2、获批后，所有申请人需在港缴费领取新签证"
            view.textColor = UIColor.mainTextColor50
            view.font = UIFont.PFSC_R(ofSize: 14)
            view.numberOfLines = 0
            return view
        }()
        addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.left.equalTo(20)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
    }

}
