//
//  YHGCPreviewBasiceInformationViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 *基本资料信息 预览
 */
class YHGCPreviewBasiceInformationViewController: YHPreviewBaseViewController {
    private let previewVM: YHGCPreviewViewModel =  YHGCPreviewViewModel()
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
    
}

private extension YHGCPreviewBasiceInformationViewController {
    
    func setupUI() {
        self.homeTableView.register(YHPreviewInfoCell.self, forCellReuseIdentifier: YHPreviewInfoCell.cellReuseIdentifier)
        self.homeTableView.reloadData()
    }
    
    func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            previewVM.getPreviewForBasicInfo(params: ["order_id": orderID]) { success, _ in
                if success == true {
                    
                } else {
                    
                }
                self.homeTableView.reloadData()
            }
        } else {
            printLog("error : orderID 为空")
        }
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHGCPreviewBasiceInformationViewController {
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return previewVM.arrDataForBasicInfo.count
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHPreviewInfoCell.self)
        cell.selectionStyle = .none
        cell.model = previewVM.arrDataForBasicInfo[indexPath.row]
        return cell
    }
}
