//
//  YHPlanModel.swift
//  galaxy
//
//  Created by Dufet on 2025/3/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHPlanListModel: SmartCodable {
    
    var basic: YHPlanValueChartInfo = YHPlanValueChartInfo()
    var list: [YHPlanAnalyzeModel] = []
    var plan_article_case: [YHPlanCaseModel] = []
    var plan_article_policy: [YHPlanCaseModel] = []
    var code: String = ""
    var share_url: String = ""
    var pdf_url: String = ""
    
    required init() {
        
    }
}

class YHPlanCaseModel: SmartCodable {
    
    var title: String = ""
    var img_url: String = ""
    var image_poster: String = ""
    
    required init() {
        
    }
}

class YHPlanValueChartInfo: SmartCodable {
    
    var work_score: String = ""
    var live_score: String = ""
    var invest_score: String = ""
    var stay_time_score: String = ""
    var result: String = ""
    var level_name: String = ""
    
    required init() {
        
    }
}

class YHPlanProductModel: SmartCodable {
    
    var title: String = ""
    var description: String = ""
    var img_url: String = ""
    var recommend_product_ids: [Int] = []
    
    required init() {
        
    }
}

class YHPlanAnalyzeModel: SmartCodable {
    
    var name: String = ""
    var score: String = "0.0"
    var current_state: String = ""
    var suggest: String = ""
    var hong_kong_policy: String = ""
    var solution_plan: [YHPlanProductModel] = []
    
    func getTitle() -> String {
        
        if name == "work" {
            return "工作"
        }
        
        if name == "live" {
            return "生活"
        }
        
        if name == "invest" {
            return "投资"
        }
        
        if name == "stay" {
            return "逗留"
        }
        
        return ""
    }
    
    required init() {
        
    }
    
}
