//
//  YHContact.swift
//  galaxy
//
//  Created by Dufet on 2025/9/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

// 联系人数据模型
class YHContact: SmartCodable {
    
    var name: String = ""
    var title: String = ""
    var industry: String = ""
    var description: String = ""
    var isVIP: Bool = false
//    var relationship: ContactRelationship = ContactRelationship.none
    
    required init() {
        
    }
}

enum ContactRelationship {
    case none
    case friend
    case sentRequest
    
    var buttonText: String {
        switch self {
        case .none:
            return "添加好友"
        case .friend:
            return "对方已是您的好友"
        case .sentRequest:
            return "已发送好友申请"
        }
    }
    
    var isInteractable: Bool {
        switch self {
        case .none:
            return true
        case .friend, .sentRequest:
            return false
        }
    }
    
    var buttonColor: UIColor {
        switch self {
        case .none:
            return .systemBlue
        case .friend, .sentRequest:
            return .systemGray3
        }
    }
}
