//
//  YHConnectListCellTableViewCell.swift
//  galaxy
//
//  Created by Dufet on 2025/9/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHConnectListCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHConnectListCell"
    
    private lazy var avatarImageView: UIImageView = {
        let imageView = UIImageView()
        imageView.layer.cornerRadius = 22
        imageView.clipsToBounds = true
        imageView.contentMode = .scaleAspectFill
        imageView.backgroundColor = UIColor.brandGrayColor3
        return imageView
    }()

    private lazy var nameLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 15)
        label.textColor = UIColor.brandGrayColor8
        label.text = "XXXXXXXXXXXX"
        return label
    }()

    private lazy var vipImgView: UIImageView = {
        let imageView = UIImageView()
        return imageView
    }()

    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textColor = UIColor.brandGrayColor8
        label.text = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
        return label
    }()

    private lazy var descriptionLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 11)
        label.textColor = UIColor.brandGrayColor6
        label.numberOfLines = 2
        label.text = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
        return label
    }()

    lazy var addFriendButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitle("添加好友", for: .normal)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 11)
        button.setTitleColor(UIColor.brandGrayColor8, for: .normal)
        button.layer.borderWidth = 1
        button.layer.borderColor = UIColor.brandGrayColor5.cgColor
        return button
    }()
    
    private lazy var statusLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 11)
        label.textColor = UIColor.brandGrayColor6
        label.text = "已发送好友申请"
        return label
    }()

    private lazy var separatorLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.brandGrayColor3
        return view
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }

    private func setupUI() {
        selectionStyle = .none

        // 添加所有子视图
        contentView.addSubview(avatarImageView)
        contentView.addSubview(nameLabel)
        contentView.addSubview(vipImgView)
        contentView.addSubview(titleLabel)
        contentView.addSubview(descriptionLabel)
        contentView.addSubview(statusLabel)
        contentView.addSubview(addFriendButton)
        contentView.addSubview(separatorLine)

        // SnapKit 约束设置
        avatarImageView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.top.equalToSuperview().offset(20)
            make.width.height.equalTo(44)
        }

        nameLabel.snp.makeConstraints { make in
            make.top.equalTo(avatarImageView.snp.top)
            make.left.equalTo(avatarImageView.snp.right).offset(10)
            make.height.equalTo(20)
        }

        vipImgView.snp.makeConstraints { make in
            make.left.equalTo(nameLabel.snp.right).offset(4)
            make.centerY.equalTo(nameLabel)
            make.width.equalTo(43)
            make.height.equalTo(16)
        }
        
        statusLabel.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-20)
            make.centerY.equalTo(nameLabel)
            make.height.equalTo(15)
        }

        addFriendButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalTo(nameLabel.snp.bottom)
            make.width.equalTo(68)
            make.height.equalTo(25)
        }

        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(avatarImageView.snp.right).offset(10)
            make.top.equalTo(nameLabel.snp.bottom).offset(3)
            make.right.equalToSuperview().offset(-20)
        }

        descriptionLabel.snp.makeConstraints { make in
            make.left.equalTo(avatarImageView.snp.right).offset(10)
            make.top.equalTo(titleLabel.snp.bottom).offset(4)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalTo(-20)
        }

        separatorLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview()
            make.height.equalTo(1)
        }
    }

    func updateModel(_ contact: YHContact) {
        nameLabel.text = contact.name
        titleLabel.text = "\(contact.title) • \(contact.industry)"
        descriptionLabel.text = contact.description

        // VIP标签显示
        vipImgView.isHidden = !contact.isVIP

        // 按钮配置
//        addFriendButton.setTitle(contact.relationship.buttonText, for: .normal)
//        addFriendButton.isEnabled = contact.relationship.isInteractable
//        addFriendButton.setTitleColor(contact.relationship.buttonColor, for: .normal)
//        addFriendButton.layer.borderColor = contact.relationship.buttonColor.cgColor

        // 头像占位符
    }
}
