//
//  YHMySignatureDetailViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/3/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMySignatureDetailViewModel: YHBaseViewModel {
    var mainModel: YHMySignatureDetailModel?
    var pageUrl: String?
    var personalUrl: String?
    
    override init() {
        super.init()
    }
    
    func requestSignatureDetail(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.detail
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureDetailModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.mainModel = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePageURL(_ id: String, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.pageUrl
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                self.pageUrl = json.data?.peel as? String
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePersonalURL(callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personalUrl
        _ = YHNetRequest.postRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.personalUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePersonalWithNameAndPhoneURL(name: String, phone: String, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["user_name": name,
                                      "mobile": phone]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personalUrl
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.personalUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignCallBack(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.callBack
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureLook(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.look
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                self.pageUrl = json.data?.peel as? String
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureDownload(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.download
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignConfirm(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.confirm
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestFileAction(_ id: String, _ type: Int, _ newArray: [String], _ oldUrl: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id,
                                      "op_type": type,
                                      "new_url": newArray,
                                      "old_url": oldUrl]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.upload
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
//                guard let dic = json.data?.peel as? [String : Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
//                    callBackBlock(false,nil)
//                    return
//                }
//                self.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func sendEmailForDocs(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.sendMail
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else {
                callBackBlock(false, nil)
                return
            }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignBack(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.signCallBack
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestCheckPersonalStatus(_ id: String) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personal
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { _, _ in
        } failBlock: { _ in
        }
    }
}
