//
//  YHResignDocumentTipsCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHResignDocumentTipsCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHResignDocumentTipsCell"
    
    private lazy var bgView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "document_prompt_bg_small")
        return view
    }()
    
    private lazy var tipIconView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "service_step_tips")
        return view
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 13)
        label.textColor = .brandMainColor
        label.text = "填写指引"
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor50
        label.font = .PFSC_R(ofSize: 12)
        label.numberOfLines = 0
        return label
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, detail: NSAttributedString?, detailColor: UIColor = .mainTextColor50) {
        infoTitleLabel.text = title
        infoDetailLabel.textColor = detailColor
        infoDetailLabel.attributedText = detail
    }
    
    func setupCellASAttributedInfo(title: String?, detail: ASAttributedString?, detailColor: UIColor = .mainTextColor50) {
        infoTitleLabel.text = title
        infoDetailLabel.textColor = detailColor
        infoDetailLabel.attributed.text = detail
    }
}

extension YHResignDocumentTipsCell {
    
    private func setupUI() {
        updateCellCorner(.single)
        subContainerView.addSubview(bgView)
        subContainerView.addSubview(tipIconView)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.sendSubviewToBack(bgView)
        bgView.setContentCompressionResistancePriority(.defaultLow, for: .vertical)
        bgView.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        bgView.setContentHuggingPriority(.defaultLow, for: .vertical)
        bgView.setContentHuggingPriority(.defaultLow, for: .horizontal)
        bgView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        tipIconView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.top.equalToSuperview().offset(18)
            make.width.height.equalTo(14)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(tipIconView.snp.right).offset(8)
            make.centerY.equalTo(tipIconView)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalTo(tipIconView.snp.bottom).offset(8)
            make.left.equalTo(tipIconView.snp.left)
            make.right.lessThanOrEqualToSuperview().offset(-16)
            make.bottom.equalToSuperview().offset(-16)
        }
    }
}
