//
//  YHMyNewNameCardViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/9/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import AttributedString
import JXSegmentedView
import UIKit

class YHNewNameCardViewController: YHBaseViewController {
    
    var defaultIndex = 0

    lazy var headerView: UIView = {
        let view = UIView()
        view.clipsToBounds = true
        view.backgroundColor = UIColor(hexString: "#E2E3E8")
        let bgImgView = UIImageView()
        bgImgView.image = UIImage(named: "name_card_bg")
        view.addSubview(bgImgView)
        bgImgView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(bgImgView.snp.width).multipliedBy(300.0 / 375.0)
        }
        return view
    }()

    lazy var avatarImgView: UIImageView = {
        let avatarImgV = UIImageView()
        avatarImgV.backgroundColor = UIColor.brandGrayColor8
        avatarImgV.layer.cornerRadius = 68.0 / 2
        avatarImgV.clipsToBounds = true
        return avatarImgV
    }()

    lazy var editBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setBackgroundImage(UIImage(named: "name_card_edit"), for: .normal)
        return btn
    }()

    lazy var nameTextView: UITextView = {
        let textView = UITextView()
        textView.textColor = UIColor.brandGrayColor8
        textView.backgroundColor = .clear
        textView.font = UIFont.PFSC_M(ofSize: 21)
        textView.isScrollEnabled = false
        textView.isEditable = false
        textView.isSelectable = false
        return textView
    }()

    lazy var professionalLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandGrayColor8
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.numberOfLines = 2
        return label
    }()

    lazy var signatureLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandGrayColor8
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.numberOfLines = 2
        return label
    }()

    lazy var cityLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandGrayColor8
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize: 10)
        label.layer.cornerRadius = 9.0
        label.layer.borderColor = UIColor.brandGrayColor8.cgColor
        label.layer.borderWidth = 0.5
        return label
    }()

    lazy var zodiacLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.brandGrayColor8
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize: 10)
        label.layer.cornerRadius = 9.0
        label.layer.borderColor = UIColor.brandGrayColor8.cgColor
        label.layer.borderWidth = 0.5
        label.frame = CGRect(x: 0, y: 0, width: 42, height: 18)
        return label
    }()

    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.titles = ["主页", "动态"]
        dataSource.titleNormalFont = UIFont.PFSC_R(ofSize: 14)
        dataSource.titleNormalColor = .brandGrayColor7
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 16)
        dataSource.titleSelectedColor = .brandGrayColor8
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = 32.0
        dataSource.itemSpacing = 24.0
        return dataSource
    }()

    // tab
    lazy var segmentedView: JXSegmentedView = {
        let view = JXSegmentedView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 30))
        view.backgroundColor = .white
        return view
    }()

    // 分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        JXSegmentedListContainerView(dataSource: self, type: .collectionView)
    }()

    lazy var childrenVC: [YHBaseViewController] = {
        let vc1 = YHNameCardHomePageViewController()
        let vc2 = YHNameCardHomePageViewController()
        let vcs: [YHBaseViewController] = [vc1, vc2]
        return vcs
    }()

    lazy var bottomBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("发布动态", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 13)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandGrayColor8
        btn.layer.cornerRadius = 3.0
        btn.masksToBounds = true
        return btn
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navigationBar.backgroundColor = .clear
        let rightButtonItem = UIBarButtonItem(image: UIImage(named: "name_card_authorize")?.withRenderingMode(.alwaysOriginal), style: .plain, target: self, action: #selector(authorizeBtnClicked))
        gk_navRightBarButtonItem = rightButtonItem
        gk_navItemRightSpace = 16

        createUI()
    }

    @objc func authorizeBtnClicked() {
    }

    func createUI() {
        view.backgroundColor = .white
        view.addSubview(headerView)
        headerView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
        }
        headerView.addSubview(avatarImgView)
        avatarImgView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(24 + k_Height_NavigationtBarAndStatuBar)
            make.width.height.equalTo(68)
        }
        headerView.addSubview(editBtn)
        editBtn.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.centerY.equalTo(avatarImgView)
            make.right.equalTo(-20)
        }
        headerView.addSubview(nameTextView)
        nameTextView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(avatarImgView.snp.bottom).offset(12)
        }
        headerView.addSubview(professionalLabel)
        professionalLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(nameTextView.snp.bottom).offset(4)
        }
        headerView.addSubview(signatureLabel)
        signatureLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(professionalLabel.snp.bottom).offset(6)
            make.bottom.equalTo(-32)
        }

        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        view.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(headerView.snp.bottom)
            make.height.equalTo(30)
        }

        segmentedView.listContainer = listContainerView
        view.addSubview(listContainerView)
        view.addSubview(bottomBtn)

        listContainerView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(segmentedView.snp.bottom).offset(0.0)
            make.bottom.equalTo(bottomBtn.snp.top).offset(-8)
        }
        
        bottomBtn.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(46)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom()-10)
        }

        // 分类Title
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self

        // 配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16.0
        indicator.indicatorHeight = 2.0
        indicator.indicatorColor = UIColor.brandGrayColor8
        indicator.indicatorCornerRadius = 0
        segmentedView.indicators = [indicator]
        segmentedView.defaultSelectedIndex = defaultIndex

        updateModel()
    }

    func updateModel() {
        let cityText = " 北京市 "
        cityLabel.text = cityText
        let cityWidth = getWith(font: cityLabel.font, height: 18, string: cityText)
        cityLabel.frame = CGRect(x: 0, y: 0, width: cityWidth + 8, height: 18)

        let zodiacText = " 金牛座 "
        zodiacLabel.text = zodiacText
        let zodiacWidth = getWith(font: zodiacLabel.font, height: 18, string: zodiacText)
        zodiacLabel.frame = CGRect(x: 0, y: 0, width: zodiacWidth + 8, height: 18)

//        self.signImgV.isHidden = !self.userModel.isSigned

        var name: ASAttributedString = .init(string: "阿萨德减肥啦拒收到付垃圾啊送达了开发机山卡拉", .font(UIFont.PFSC_M(ofSize: 21)), .foreground(UIColor.brandGrayColor8))
        let cityTag: ASAttributedString = "  \(.view(cityLabel, .original(.center)))"
        let zodiacTag: ASAttributedString = "  \(.view(zodiacLabel, .original(.center)))"

        nameTextView.attributed.text = name + cityTag + zodiacTag
        professionalLabel.text = "说法舒服多了撒记得发啦手机大发立卡手机大发立卡手机大发卡拉季山卡拉代发金卡拉萨放大机阿卡说法卡拉生发剂凯撒的剪发卡"
        signatureLabel.text = "阿萨德节流阀上课了打飞机阿萨漏打卡飞机王企鹅批发金娃女会计收纳大V江西子女科技哈师大聚哈挖了溶剂法搞起我金卡阿斯加德发卡量世纪东方啦苏卡达飞机阿萨达佛IE秋季日期忘记哦"
    }

    func getWith(font: UIFont, height: CGFloat, string: String) -> CGFloat {
        let size = CGSize(width: CGFloat(MAXFLOAT), height: height)
        let dic = [NSAttributedString.Key.font: font] // swift 4.2
        let strSize = string.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context: nil).size
        return CGSize(width: ceil(strSize.width), height: strSize.height).width
    }
}

extension YHNewNameCardViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
    }

    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
    }
}

extension YHNewNameCardViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        guard let vc = childrenVC[index] as? JXSegmentedListContainerViewListDelegate else {
            return YHNameCardHomePageViewController()
        }
        return vc
    }
}
