//
//  TUIYHCustomCellClickDelegate.h
//  Pods
//
//  Created by alexzzw on 2025/5/20.
//

#import <Foundation/Foundation.h>
@import ImSDK_Plus;

@class TUIFileMessageCellData;
@class TUIOrderCellData;

NS_ASSUME_NONNULL_BEGIN

/////////////////////////////////////////////////////////////////////////////////
//
//                         TUIYHCustomCellClickDelegate
//
/////////////////////////////////////////////////////////////////////////////////

@protocol TUIYHCustomCellClickDelegate <NSObject>

/**
 *  Callback for clicking file cell
 *  You can use this callback to: preview file inside the app
 *
 *  @param cellData include local file data
 */
- (void)didTapInFileCell:(TUIFileMessageCellData *)cellData;

/**
 *  Callback for clicking Custom cell
 *  You can use this callback to: preview file inside the app
 *
 *  @param cellData include local file data
 */
- (void)didTapCustomOrderCell:(TUIOrderCellData *)cellData;

@end

NS_ASSUME_NONNULL_END

