//
//  YHActivityApplyInfoView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityApplyInfoItemView: UIView {
    
    var dataModel: YHActivityApplyInfoModel? {
        didSet {
            updateUI()
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    lazy var titleLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.text = "报名信息"
        return label
    }()
    
    lazy var nameItem: YHActivityTwoItemView = {
        let view = YHActivityTwoItemView()
        return view
    }()
    
    lazy var numberItem: YHActivityTwoItemView = {
        let view = YHActivityTwoItemView()
        return view
    }()
    
    lazy var phoneItem: YHActivityTwoItemView = {
        let view = YHActivityTwoItemView()
        return view
    }()

}

extension YHActivityApplyInfoItemView {
    
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        nameItem.updateItem(title: "您的姓名", value: model.name)
        numberItem.updateItem(title: "报名人数", value: "\(model.number)人")
        phoneItem.updateItem(title: "手机号码", value: model.mobile)
    }
    
    func setupUI() {
        
        addSubview(titleLable)
        addSubview(nameItem)
        addSubview(numberItem)
        addSubview(phoneItem)
        
        titleLable.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(24)
        }
        
        nameItem.snp.makeConstraints { make in
            make.top.equalTo(titleLable.snp.bottom).offset(16)
            make.left.right.equalToSuperview()
        }
        
        numberItem.snp.makeConstraints { make in
            make.top.equalTo(nameItem.snp.bottom).offset(16)
            make.left.right.equalToSuperview()
        }
        
        phoneItem.snp.makeConstraints { make in
            make.top.equalTo(numberItem.snp.bottom).offset(16)
            make.left.right.equalToSuperview()
            
            make.bottom.equalToSuperview()
        }
    }
}
