//
//  YHVisaRenewalGuideHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/9.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHVisaRenewalGuideHeaderCell: UITableViewCell {
    static let cellReuseIdentifier = "YHVisaRenewalGuideHeaderCell"
    
    private lazy var infoTitleIcon: UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFit
        view.image = UIImage(named: "resign_visa_guide_title")
        return view
    }()
    
    private lazy var tipIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "resign_visa_guide_tips")
        return view
    }()
        
    private lazy var tipTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_B(ofSize: 14)
        label.textColor = .mainTextColor
        label.text = "香港入境处政策"
        return label
    }()
    
    private lazy var firstDotView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor30
        view.layer.cornerRadius = 3
        view.clipsToBounds = true
        return view
    }()
    
    private lazy var secondDotView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor30
        view.layer.cornerRadius = 3
        view.clipsToBounds = true
        return view
    }()
    
    private lazy var firstTipDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = .mainTextColor70
        label.text = "获批后，3个月内完成缴费，否则身份会失效"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var secondTipDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = .mainTextColor70
        label.text = "缴费领取电子签证时，涉及到的申请人应身在香港"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var subContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 6, corner: .allCorners)
        view.backgroundColor = UIColor(hexString: "#FFF5EB")
        return view
    }()
    
    private lazy var warnIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "resign_visa_guide_warn")
        return view
    }()
    
    private lazy var warnDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = UIColor(hex: 0xFF8000)
        label.text = "在港缴费领取电子签证时使用的入境证件，请务必和递交续签资料时入境香港使用的旅行证件保持一致"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var paragraphTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_B(ofSize: 16)
        label.textColor = .mainTextColor
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        label.text = "一、递交续签申请后，未离境一直在港"
        return label
    }()
    
    private lazy var paragraphDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor70
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineHeightMultiple = 1.07
        let attributedText = NSAttributedString(
            string: "一直未离港，获批后，可在港直接缴费并领取新电子签证",
            attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle]
        )
        label.attributedText = attributedText
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
 
}

extension YHVisaRenewalGuideHeaderCell {
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(infoTitleIcon)
        contentView.addSubview(tipIcon)
        contentView.addSubview(tipTitleLabel)
        contentView.addSubview(firstDotView)
        contentView.addSubview(secondDotView)
        contentView.addSubview(firstTipDetailLabel)
        contentView.addSubview(secondTipDetailLabel)
        contentView.addSubview(subContainerView)
        subContainerView.addSubview(warnIcon)
        subContainerView.addSubview(warnDetailLabel)
        contentView.addSubview(paragraphTitleLabel)
        contentView.addSubview(paragraphDetailLabel)
                
        infoTitleIcon.setContentHuggingPriority(.required, for: .vertical)
        tipTitleLabel.setContentHuggingPriority(.required, for: .vertical)
        firstTipDetailLabel.setContentHuggingPriority(.required, for: .vertical)
        secondTipDetailLabel.setContentHuggingPriority(.required, for: .vertical)
        subContainerView.setContentHuggingPriority(.required, for: .vertical)
        warnDetailLabel.setContentHuggingPriority(.required, for: .vertical)
        paragraphTitleLabel.setContentHuggingPriority(.required, for: .vertical)
        paragraphDetailLabel.setContentHuggingPriority(.required, for: .vertical)
        
        infoTitleIcon.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(5)
            make.left.equalToSuperview().offset(22)
            make.height.equalTo(25)
            make.width.equalTo(253)
        }
        
        tipIcon.snp.makeConstraints { make in
            make.top.equalTo(infoTitleIcon.snp.bottom).offset(34)
            make.left.equalToSuperview().offset(20)
            make.height.equalTo(20)
            make.width.equalTo(20)
        }
        tipTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(tipIcon.snp.right).offset(8)
            make.centerY.equalTo(tipIcon)
        }
        
        firstDotView.snp.makeConstraints { make in
            make.top.equalTo(tipIcon.snp.bottom).offset(19)
            make.left.equalTo(tipIcon)
            make.height.equalTo(6)
            make.width.equalTo(6)
        }
        
        firstTipDetailLabel.snp.makeConstraints { make in
            make.top.equalTo(tipIcon.snp.bottom).offset(12)
            make.left.equalTo(firstDotView.snp.right).offset(6)
            make.right.lessThanOrEqualToSuperview().offset(-20)
        }
        
        secondDotView.snp.makeConstraints { make in
            make.top.equalTo(firstTipDetailLabel.snp.bottom).offset(19)
            make.left.equalTo(tipIcon)
            make.height.equalTo(6)
            make.width.equalTo(6)
        }
        
        secondTipDetailLabel.snp.makeConstraints { make in
            make.top.equalTo(firstTipDetailLabel.snp.bottom).offset(12)
            make.left.equalTo(secondDotView.snp.right).offset(6)
            make.right.lessThanOrEqualToSuperview().offset(-20)
        }
        
        subContainerView.snp.makeConstraints { make in
            make.top.equalTo(secondTipDetailLabel.snp.bottom).offset(20)
            make.left.equalTo(tipIcon)
            make.right.equalToSuperview().offset(-20)
        }
        
        warnIcon.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.top.equalToSuperview().offset(19)
            make.width.height.equalTo(14)
        }
        
        warnDetailLabel.snp.makeConstraints { make in
            make.left.equalTo(warnIcon.snp.right).offset(8)
            make.right.equalToSuperview().offset(-16)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        paragraphTitleLabel.snp.makeConstraints { make in
            make.top.equalTo(subContainerView.snp.bottom).offset(20)
            make.left.equalTo(tipIcon)
            make.right.lessThanOrEqualToSuperview().offset(-20)
        }
        
        paragraphDetailLabel.snp.makeConstraints { make in
            make.top.equalTo(paragraphTitleLabel.snp.bottom).offset(12)
            make.left.equalTo(tipIcon)
            make.right.lessThanOrEqualToSuperview().offset(-20)
            make.bottom.equalToSuperview()
        }
    }
}
