//
//  YHResignUploadDocListViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignUploadDocListViewModel: YHBaseViewModel {
    // 列表信息
    var mainModel: YHResignUploadDocListModel = YHResignUploadDocListModel()
}

extension YHResignUploadDocListViewModel {
    
    func getUploadDocList(orderID: Int, stepID: Int, callBackBlock: @escaping (_ success: Bool, _ err: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": orderID, "renewal_id": stepID]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignUploadDoc.list
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignUploadDocListModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, err)
                    return
                }
                self.mainModel = resultModel
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
}
