//
//  YHPreviewInfoQuestionAndAnswerView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoQuestionAndAnswerItemView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
   
    // title
    private lazy var nameLable: UILabel = {
        let lable0 = UILabel(text: "--")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byCharWrapping
        return lable0
    }()
    
    // subtitleLable
    private lazy var subtitleLable: UILabel = {
        let lable0 = UILabel(text: "--")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        return lable0
    }()
    
    // remarkLable
    private lazy var remarkLable: UILabel = {
        let lable0 = UILabel(text: "--")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        lable0.text = "--"
        return lable0
    }()
    
    private lazy var remarkHoldView: UIView =  {
        let view = UIView()
        view.backgroundColor = .contentBkgColor
        view.layer.cornerRadius = kCornerRadius6
        view.clipsToBounds = true
        view.isHidden = true
        return view
    }()
    
    private func setupUI() {
        addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(18)
            make.left.equalToSuperview()
            make.right.equalToSuperview()
        }
        
        addSubview(subtitleLable)
    }
    
    var dataModel: YHPreviewQuestionAndAnswerModel? {
        didSet {
            updateUI()
        }
    }
}

extension YHPreviewInfoQuestionAndAnswerItemView {
    func updateUI() {
        guard let model = dataModel else { return }
        
        removeSubviews()
        setupUI()
        
        nameLable.text = model.question
        subtitleLable.text = model.answer
        
        if let remark = model.remark, remark.isEmpty == false {
            subtitleLable.snp.makeConstraints { make in
                make.top.equalTo(nameLable.snp.bottom).offset(8)
                make.right.equalToSuperview()
                make.left.equalToSuperview()
            }
            
            addSubview(remarkHoldView)
            remarkHoldView.snp.makeConstraints { make in
                make.top.equalTo(subtitleLable.snp.bottom).offset(8)
                make.right.equalToSuperview()
                make.left.equalToSuperview()
            }
            remarkHoldView.addSubview(remarkLable)
            remarkLable.snp.makeConstraints { make in
                make.top.left.equalTo(12)
                make.bottom.right.equalTo(-12)
            }
            
            remarkLable.text = remark
            remarkHoldView.isHidden = false
            remarkHoldView.snp.makeConstraints { make in
                make.top.equalTo(subtitleLable.snp.bottom).offset(8)
                make.right.equalToSuperview()
                make.left.equalToSuperview()
                make.bottom.equalToSuperview()
            }
        } else {
            
            subtitleLable.snp.makeConstraints { make in
                make.top.equalTo(nameLable.snp.bottom).offset(8)
                make.right.equalToSuperview()
                make.left.equalToSuperview()
                make.bottom.equalToSuperview()
            }
        }
    }
}
