//
//  YHWorkExperienceTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHWorkExperienceTableViewCell: UITableViewCell {
    typealias WorkExperienceBlock = (_ model: YHWorkExperienceModel) -> Void
    typealias CompanyBlock = (_ model: YHCompanyModelListModel) -> Void
    typealias SelectBlock = (_ selectIndex: [Int]) -> Void
    var companyBlock: CompanyBlock?
    var workExperienceBlock: WorkExperienceBlock?
    var selectBlock: SelectBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var mainItemView: UIView!
    var selectItem: Int = 5
    var workId: Int = 0
    var orderId: Int = 0
    var dataSource: YHSectionWorkExperienceModel? {
        didSet {
            updateAllViews()
        }
    }
    var selectDataSource: [ASAttributedString]?

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(52)
        }
    }
    
    func updateAllViews() {
        titleLabel.text = dataSource?.title
        mainItemView.removeSubviews()
        var y = 0
        for i in 0 ..< (dataSource?.models?.count ?? 0) {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(1)
                make.right.equalTo(-18)
            }
            y += 1
            let data = dataSource?.models?[i]
            let isShow = data?.isShowPrompts ?? false
            let message = data?.message ?? ""
            var h = 51
            if isShow && message.count == 0 {
                h += 20
            }
            let itemView = YHWorkExperienceItemView()
            itemView.dataSource = data
            itemView.workId = workId
            itemView.orderId = orderId
            itemView.block = {[weak self] model in
                guard let self = self else { return }
                if let block = self.workExperienceBlock {
                    block(model)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(y)
                make.height.equalTo(h)
                make.right.equalTo(-18)
            }
            y += h
            if i == 1 {
                let view = YHWorkExperienceSelectView(frame: CGRect(x: 0, y: y, width: Int(KScreenWidth) - 32, height: 386))
                view.selectItem = [selectItem]
                view.dataSource = selectDataSource
                view.selectBlock = { [weak self] index in
                    guard let self = self else { return }
                    if let block = self.selectBlock {
                        block(index)
                    }
                }
                mainItemView.addSubview(view)
                y += 451
            }
        }
    }
}
