//
//  NSAttributedString+Extension.swift
//  BaiSiSMApp
//
//  Created by Davidhuang on 2022/12/6.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit

extension NSAttributedString {
    
    // 添加富文本
    public class func bs_create(string str: String, font: UIFont? = nil, color textColor: UIColor? = nil, url: String? = nil, lineSpacing: CGFloat? = nil) -> NSAttributedString {
        var attributes: [NSAttributedString.Key: Any] = [:]
        if let font = font {
            attributes[.font] = font
        }
        if let textColor = textColor {
            attributes[.foregroundColor] = textColor
        }
        if let url = url {
            // 添加链接文本
            attributes[.link] = url
        }
        if let lineSpacing = lineSpacing {
            // 格式调整
            let style = NSMutableParagraphStyle()
            /**调行间距*/
            style.lineSpacing = lineSpacing
            style.alignment = .left
            attributes[.paragraphStyle] = style
        }
        let attributedString = NSAttributedString(string: str, attributes: attributes)
        return attributedString
    }
    
    // 添加图片
    public class func gd_create(image: UIImage) -> NSAttributedString {
        let textAttachment = NSTextAttachment()
        textAttachment.image = image
        let attrStringWithImage = NSAttributedString(attachment: textAttachment)
        return attrStringWithImage
    }
    
}

extension NSAttributedString {
    
    /// 富文本转html字符串
    public class func attriToStr(attri: NSAttributedString) -> String {
        let tempDic: [NSAttributedString.DocumentAttributeKey: Any] =
        [NSAttributedString.DocumentAttributeKey.documentType:
            NSAttributedString.DocumentType.html,
         NSAttributedString.DocumentAttributeKey.characterEncoding:
            String.Encoding.utf8.rawValue]
        do {
            let htmlData = try attri.data(from: NSRange(location: 0, length: attri.length-1), documentAttributes: tempDic)
            return String(data: htmlData, encoding: String.Encoding.utf8) ?? ""
        } catch {
            return ""
        }
    }
    
    /// 字符串转富文本
    public class func strToAttri(htmlStr: String) -> NSAttributedString {
        guard let data = htmlStr.data(using: String.Encoding.unicode) else {
            return NSAttributedString()
        }
        do {
            let attri = try NSAttributedString(data: data, options: [NSAttributedString.DocumentReadingOptionKey.documentType: NSAttributedString.DocumentType.html], documentAttributes: nil)
            return attri
        } catch {
            return NSAttributedString()
        }
    }
    
}

extension NSMutableAttributedString {
    
    // 添加图片和点击事件
    public class func bs_create(image: UIImage) -> NSMutableAttributedString {
        let textAttachment = NSTextAttachment()
        textAttachment.image = image
        let attrStringWithImage = NSMutableAttributedString(attachment: textAttachment)
        attrStringWithImage.addAttributes([.link: "checkbox://"], range: NSRange(location: 0, length: attrStringWithImage.length))
        return attrStringWithImage
    }
    
    public func setStyle(lineSpacing: CGFloat) {
        // 格式调整
        let style = NSMutableParagraphStyle()
        /**调行间距*/
        style.lineSpacing = lineSpacing
        style.alignment = .left
        self.addAttributes([NSAttributedString.Key.paragraphStyle: style], range: NSRange(location: 0, length: self.string.count))
    }
    
}

extension NSAttributedString {
    func yh_height(containerWidth: CGFloat) -> CGFloat {
        let rect = boundingRect(with: CGSize(width: containerWidth, height: CGFloat.greatestFiniteMagnitude),
                                options: [.usesLineFragmentOrigin, .usesFontLeading],
                                context: nil)
        return ceil(rect.size.height)
    }

    func yh_width(containerHeight: CGFloat) -> CGFloat {
        let rect = boundingRect(with: CGSize(width: CGFloat.greatestFiniteMagnitude, height: containerHeight),
                                options: [.usesLineFragmentOrigin, .usesFontLeading],
                                context: nil)
        return ceil(rect.size.width)
    }
}
