//
//  YHMyFunctionGroupItem2Cell.swift
//  galaxy
//
//  Created by Dufet on 2025/2/13.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyFunctionGroupItem2Cell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHMyFunctionGroupItem2Cell"
    
    func updateItem(_ item: PersonalModuleItem) {
        
        titleLabel.text = item.title
        descLabel.text = item.desc
        
        if let icon = item.icon, !icon.isEmpty {
            iconImgView.image = UIImage(named: icon)
        } else {
            iconImgView.image = nil
        }
    }
    
    lazy var whiteView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 4.0
        view.clipsToBounds = true
        return view
    }()

    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize: 14)
        return label
    }()
    
    lazy var descLabel: UILabel = {
        let label = UILabel()
        label.textColor = .init(UIColor(hex: 0x8993A2))
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 12)
        return label
    }()
    
    lazy var iconImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: ""))
        return v
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    func setupUI() {
        
        self.contentView.addSubview(whiteView)
        self.whiteView.addSubview(titleLabel)
        self.whiteView.addSubview(descLabel)
        self.whiteView.addSubview(iconImgView)
        
        whiteView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }

        iconImgView.snp.makeConstraints { make in
            make.left.equalTo(12)
            make.width.height.equalTo(42)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgView.snp.right).offset(8)
            make.right.equalTo(-8)
            make.top.equalTo(iconImgView)
            make.right.equalTo(-8)
            make.height.equalTo(20)
        }
        
        descLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel)
            make.top.equalTo(titleLabel.snp.bottom).offset(2)
            make.height.equalTo(17)
            make.right.equalTo(-8)
        }

    }
}
